/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.mail;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventListener;
import com.atlassian.jira.event.listeners.mail.IssueEventBundleMailHandler;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.event.user.UserEventListener;
import com.atlassian.jira.mail.UserMailQueueItem;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import java.util.Map;

public class MailListener
extends AbstractIssueEventListener
implements IssueEventListener,
UserEventListener {
    private final UserManager userManager;
    private final IssueEventBundleMailHandler issueEventBundleMailHandler;
    private final MailQueue mailQueue;
    private final IssueEventBundleFactory issueEventBundleFactory;

    public MailListener(UserManager userManager, IssueEventBundleMailHandler issueEventBundleMailHandler, MailQueue mailQueue, IssueEventBundleFactory issueEventBundleFactory) {
        this.userManager = userManager;
        this.issueEventBundleMailHandler = issueEventBundleMailHandler;
        this.mailQueue = mailQueue;
        this.issueEventBundleFactory = issueEventBundleFactory;
    }

    public void init(Map params) {
    }

    public String[] getAcceptedParams() {
        return new String[0];
    }

    public boolean isInternal() {
        return true;
    }

    public boolean isUnique() {
        return true;
    }

    public String getDescription() {
        return "For each user or issue event, generate an appropriate email, and send to the required participants.";
    }

    public void userSignup(UserEvent event) {
        if (Boolean.TRUE.equals(event.getParams().get("sendEmail"))) {
            this.sendUserMail(event, "Account signup", "template.user.signup.subject", "usersignup.vm");
        }
    }

    public void userCreated(UserEvent event) {
        if (Boolean.TRUE.equals(event.getParams().get("sendEmail"))) {
            if (this.userManager.canUpdateUserPassword(event.getUser())) {
                this.sendUserMail(event, "Account created", "template.user.created.subject", "usercreated.vm");
            } else {
                this.sendUserMail(event, "Account created", "template.user.created.subject", "usercreated-nopassword.vm");
            }
        }
    }

    public void userForgotPassword(UserEvent event) {
        this.sendUserMail(event, "Account password", "template.user.forgotpassword.subject", "forgotpassword.vm");
    }

    public void userForgotUsername(UserEvent event) {
        this.sendUserMail(event, "Account usernames", "template.user.forgotusername.subject", "forgotusernames.vm");
    }

    public void userCannotChangePassword(UserEvent event) {
        this.sendUserMail(event, "Account usernames", "template.user.cannotchangepassword.subject", "cannotchangepassword.vm");
    }

    protected void sendUserMail(UserEvent event, String subject, String subjectKey, String template) {
        if (ImportUtils.isEnableNotifications()) {
            UserMailQueueItem item = new UserMailQueueItem(event, subject, subjectKey, template);
            this.mailQueue.addItem((MailQueueItem)item);
        }
    }

    @EventListener
    public void handleIssueEventBundle(IssueEventBundle bundle) {
        this.issueEventBundleMailHandler.handle(bundle);
    }

    protected void handleDefaultIssueEvent(IssueEvent event) {
        if (event.isRedundant()) {
            return;
        }
        this.handleIssueEventBundle(this.issueEventBundleFactory.wrapInBundle(event));
    }
}

