/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.property;

import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.Timestamp;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EntityPropertyImpl
implements EntityProperty {
    private final Long id;
    private final String entityName;
    private final Long entityId;
    private final String key;
    private final String value;
    private final Timestamp created;
    private final Timestamp updated;

    private EntityPropertyImpl(Long id, String entityName, Long entityId, String key, String value, Timestamp created, Timestamp updated) {
        this.id = id;
        this.entityName = (String)Assertions.notNull((String)"entityName", (Object)entityName);
        this.entityId = (Long)Assertions.notNull((String)"entityId", (Object)entityId);
        this.key = (String)Assertions.notNull((String)"key", (Object)key);
        this.value = (String)Assertions.notNull((String)"value", (Object)value);
        this.created = (Timestamp)Assertions.notNull((String)"created", (Object)created);
        this.updated = (Timestamp)Assertions.notNull((String)"updated", (Object)updated);
    }

    public static EntityProperty existing(Long id, String entityName, Long entityId, String key, String value, Timestamp created, Timestamp updated) {
        return new EntityPropertyImpl((Long)Assertions.notNull((String)"id", (Object)id), entityName, entityId, key, value, created, updated);
    }

    public static EntityProperty forCreate(String entityName, Long entityId, String key, String value) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        return new EntityPropertyImpl(null, entityName, entityId, key, value, now, now);
    }

    public Long getId() {
        return this.id;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public Timestamp getUpdated() {
        return this.updated;
    }

    public String toString() {
        return "EntityPropertyImpl[id=" + this.id + ",entityName=" + this.entityName + ",entityId=" + this.entityId + ",key=" + this.key + ",value=" + (this.value.length() > 70 ? this.value.substring(0, 64) + " ..." : this.value) + ",created=" + this.created + ",updated=" + this.updated + ']';
    }
}

