/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.datetime.JodaFormatterSupplier;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class JodaFormatterCache
implements JodaFormatterSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(JodaFormatterCache.class);
    @ClusterSafe
    private final LoadingCache<JodaFormatterSupplier.Key, DateTimeFormatter> cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new CreateFormatter()));

    JodaFormatterCache() {
    }

    @Override
    public DateTimeFormatter get(JodaFormatterSupplier.Key key) {
        return (DateTimeFormatter)this.cache.getUnchecked((Object)key);
    }

    public void clear() {
        LOGGER.trace("Clearing cache: {}", (Object)this);
        this.cache.invalidateAll();
    }

    private class CreateFormatter
    implements Function<JodaFormatterSupplier.Key, DateTimeFormatter> {
        private CreateFormatter() {
        }

        public DateTimeFormatter apply(@Nullable JodaFormatterSupplier.Key key) {
            LOGGER.trace("Creating formatter for {}", (Object)key);
            return DateTimeFormat.forPattern((String)key.pattern).withLocale(key.locale);
        }
    }
}

