/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public enum DateInputAdapter {
    INSTANCE;

    private final List<Rule> rules = ImmutableList.of((Object)Rule.replace("Mrz", "M\u00e4r").in(Locale.GERMANY), (Object)Rule.replace("Marz", "M\u00e4r").in(Locale.GERMANY), (Object)Rule.replace("Mar", "M\u00e4r").in(Locale.GERMANY));

    public String adapt(String date, Locale locale) {
        for (Rule rule : this.rules) {
            date = rule.apply(date, locale);
        }
        return date;
    }

    private static final class Rule {
        private final Locale locale;
        private final Pattern pattern;
        private final String replacement;

        public static Rule replace(String original, String replacement) {
            Pattern pattern = Pattern.compile("([^\\w]|^)" + original + "([^\\w]|$)", 2);
            return new Rule(null, pattern, "$1" + replacement + "$2");
        }

        public Rule in(Locale locale) {
            return new Rule(locale, this.pattern, this.replacement);
        }

        private Rule(Locale locale, Pattern pattern, String replacement) {
            this.locale = locale;
            this.pattern = pattern;
            this.replacement = replacement;
        }

        public String apply(String text, Locale locale) {
            if (text != null && (this.locale == null || this.locale.equals(locale))) {
                return this.pattern.matcher(text).replaceAll(this.replacement);
            }
            return text;
        }
    }
}

