/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.database.DatabaseConnection;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.IdGeneratingSQLInsertClause;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.model.querydsl.JiraRelationalPathBase;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Connection;
import java.sql.SQLException;
import org.ofbiz.core.entity.DelegatorInterface;

public class DbConnectionImpl
implements DbConnection {
    private final Connection con;
    private final SQLTemplates dialect;
    private final DelegatorInterface genericDelegator;

    DbConnectionImpl(Connection con, SQLTemplates dialect, DelegatorInterface genericDelegator) {
        this.con = con;
        this.dialect = dialect;
        this.genericDelegator = genericDelegator;
    }

    DbConnectionImpl(DatabaseConnection databaseConnection, SQLTemplates dialect, DelegatorInterface delegatorInterface) {
        this(databaseConnection.getJdbcConnection(), dialect, delegatorInterface);
    }

    @Override
    public Connection getJdbcConnection() {
        return this.con;
    }

    public SQLQuery newSqlQuery() {
        return new SQLQuery(this.con, this.dialect);
    }

    @Override
    public SQLUpdateClause update(RelationalPath<?> entity) {
        return new SQLUpdateClause(this.con, this.dialect, entity);
    }

    @Override
    public IdGeneratingSQLInsertClause insert(JiraRelationalPathBase<?> entity) {
        return new IdGeneratingSQLInsertClause(this.con, this.dialect, entity, this.genericDelegator);
    }

    @Override
    public SQLDeleteClause delete(RelationalPath<?> entity) {
        return new SQLDeleteClause(this.con, this.dialect, entity);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        try {
            this.con.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }

    @Override
    public void commit() {
        try {
            this.con.commit();
        }
        catch (SQLException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }

    @Override
    public void rollback() {
        try {
            this.con.rollback();
        }
        catch (SQLException ex) {
            throw new DataAccessException((Throwable)ex);
        }
    }
}

