/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.cache.Cache;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Functions;
import com.atlassian.jira.util.Visitor;
import io.atlassian.util.concurrent.LazyReference;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class UserOrGroupCache<T extends UserOrGroupStub> {
    private static final Logger LOG = LoggerFactory.getLogger(UserOrGroupCache.class);
    private final AtomicBoolean forceRefresh = new AtomicBoolean();
    private final String entityName;
    private final ResettableLazyReference<Cache<DirectoryEntityKey, T>> cacheRef;

    UserOrGroupCache(String entityName) {
        this.entityName = entityName;
        this.cacheRef = new ResettableLazyReference<Cache<DirectoryEntityKey, T>>(){

            protected Cache<DirectoryEntityKey, T> create() throws Exception {
                Cache cache = UserOrGroupCache.this.createCache();
                UserOrGroupCache.this.buildCacheIfRequired(cache);
                return cache;
            }
        };
    }

    Cache<DirectoryEntityKey, T> getCache() {
        try {
            return (Cache)this.cacheRef.get();
        }
        catch (LazyReference.InitializationException ex) {
            this.cacheRef.reset();
            throw ex;
        }
    }

    public void refresh() {
        this.forceRefresh.set(true);
        this.cacheRef.reset();
        this.getCache();
    }

    @Nullable
    public T getCaseInsensitive(long directoryId, String name) {
        DirectoryEntityKey key1;
        Cache<DirectoryEntityKey, T> cache = this.getCache();
        UserOrGroupStub result = (UserOrGroupStub)cache.get((Object)(key1 = DirectoryEntityKey.getKeyPreserveCase(directoryId, name)));
        if (result != null) {
            return (T)result;
        }
        DirectoryEntityKey key2 = DirectoryEntityKey.getKeyLowerCase(directoryId, name);
        return (T)(key1.getName() != key2.getName() ? (UserOrGroupStub)cache.get((Object)key2) : null);
    }

    @Nullable
    public T getCaseSensitive(long directoryId, String name) {
        return (T)((UserOrGroupStub)this.getCache().get((Object)DirectoryEntityKey.getKeyPreserveCase(directoryId, name)));
    }

    public Collection<DirectoryEntityKey> getKeys() {
        return this.getCache().getKeys();
    }

    public DirectoryEntityKey refresh(T value) {
        DirectoryEntityKey key = DirectoryEntityKey.getKeyFor(value);
        this.getCache().put((Object)key, value);
        return key;
    }

    public void remove(long directoryId, String name) {
        this.remove(DirectoryEntityKey.getKeyLowerCase(directoryId, name));
    }

    public void remove(DirectoryEntityKey key) {
        this.getCache().remove((Object)key);
    }

    public void removeAll() {
        this.getCache().removeAll();
    }

    public void buildCacheIfRequired(Cache<DirectoryEntityKey, T> cache) {
        Lock lock = this.getLock();
        lock.lock();
        try {
            this.buildCacheIfRequiredUnderLock(cache);
        }
        finally {
            lock.unlock();
        }
    }

    @ClusterSafe(value="the use of Cache.getKeys() is safe, as users and groups are fully populated, canonical caches")
    @GuardedBy(value="getLock()")
    private void buildCacheIfRequiredUnderLock(Cache<DirectoryEntityKey, T> cache) {
        if (this.forceRefresh.get()) {
            this.buildCacheForced(cache);
            return;
        }
        long expectedCount = this.countAllUsingDatabase();
        long actualCount = cache.getKeys().size();
        if (actualCount >= expectedCount) {
            LOG.debug("Cache size matched entity count (once under lock); skipping cache rebuild for " + this.entityName);
        } else {
            LOG.debug("Cache size (" + actualCount + ") < " + this.entityName + " database size; refreshing...");
            this.visitAllUsingDatabase(new PutIfAbsentVisitor(cache));
        }
    }

    @GuardedBy(value="getLock()")
    private void buildCacheForced(Cache<DirectoryEntityKey, T> cache) {
        LOG.debug("Forced hard refresh of " + this.entityName + " cache");
        cache.removeAll();
        this.visitAllUsingDatabase(new PutVisitor(cache));
        this.forceRefresh.set(false);
    }

    @ClusterSafe(value="the use of Cache.getKeys() is safe, as users and groups are fully populated, canonical caches")
    public List<T> getAll() {
        Cache<DirectoryEntityKey, T> cache = this.getCache();
        Collection keys = cache.getKeys();
        ArrayList<UserOrGroupStub> values = new ArrayList<UserOrGroupStub>(keys.size());
        for (DirectoryEntityKey key : keys) {
            UserOrGroupStub value = (UserOrGroupStub)cache.get((Object)key);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public List<T> getAllInDirectory(long directoryId) {
        return this.getAllInDirectory(directoryId, Functions.identity());
    }

    public List<String> getAllNamesInDirectory(long directoryId) {
        return this.getAllInDirectory(directoryId, new GetNameFunction());
    }

    @ClusterSafe(value="the use of Cache.getKeys() is safe, as users and groups are fully populated, canonical caches")
    public void visitAllInDirectory(long directoryId, Visitor<T> visitor) {
        Cache<DirectoryEntityKey, T> cache = this.getCache();
        for (DirectoryEntityKey key : cache.getKeys()) {
            UserOrGroupStub value;
            if (key.getDirectoryId() != directoryId || (value = (UserOrGroupStub)cache.get((Object)key)) == null) continue;
            visitor.visit((Object)value);
        }
    }

    @ClusterSafe(value="the use of Cache.getKeys() is safe, as users and groups are fully populated, canonical caches")
    public <R> List<R> getAllInDirectory(long directoryId, final Function<T, R> function) {
        final ArrayList list = new ArrayList(256);
        this.visitAllInDirectory(directoryId, new Visitor<T>(){

            public void visit(T element) {
                list.add(function.apply(element));
            }
        });
        return list;
    }

    abstract Lock getLock();

    abstract Cache<DirectoryEntityKey, T> createCache();

    abstract long countAllUsingDatabase();

    @GuardedBy(value="getLock()")
    public abstract void visitAllUsingDatabase(Visitor<T> var1);

    static class GetNameFunction<T extends UserOrGroupStub>
    implements Function<T, String> {
        GetNameFunction() {
        }

        public String apply(UserOrGroupStub value) {
            return value.getName();
        }
    }

    class PutIfAbsentVisitor
    implements Visitor<T> {
        private final Cache<DirectoryEntityKey, T> cache;

        PutIfAbsentVisitor(Cache<DirectoryEntityKey, T> cache) {
            this.cache = cache;
        }

        public void visit(T value) {
            DirectoryEntityKey key = DirectoryEntityKey.getKeyFor(value);
            if (this.cache.get((Object)key) == null) {
                this.cache.put((Object)key, value);
            }
        }
    }

    class PutVisitor
    implements Visitor<T> {
        private final Cache<DirectoryEntityKey, T> cache;

        PutVisitor(Cache<DirectoryEntityKey, T> cache) {
            this.cache = cache;
        }

        public void visit(T value) {
            this.cache.put((Object)DirectoryEntityKey.getKeyFor(value), value);
        }
    }
}

