/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizDirectoryDao;
import com.atlassian.jira.crowd.embedded.ofbiz.RemoteAddressEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizHelper;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.ofbiz.core.entity.GenericValue;

public class OfBizApplication
extends ApplicationImpl {
    private DirectoryDao directoryDao;
    private static final EnumSet<OperationType> ALLOWED_OPERATIONS = EnumSet.allOf(OperationType.class);

    private OfBizApplication(GenericValue applicationGenericValue, List<GenericValue> remoteAddressGenericValue) {
        Assertions.notNull((Object)applicationGenericValue);
        this.id = applicationGenericValue.getLong("id");
        this.setName(applicationGenericValue.getString("name"));
        this.setCredential(new PasswordCredential(applicationGenericValue.getString("credential"), true));
        this.setType(ApplicationType.valueOf((String)applicationGenericValue.getString("applicationType")));
        this.active = BooleanUtils.toBoolean((int)applicationGenericValue.getInteger("active"));
        this.createdDate = OfBizHelper.convertToUtilDate(applicationGenericValue.getTimestamp("createdDate"));
        this.updatedDate = OfBizHelper.convertToUtilDate(applicationGenericValue.getTimestamp("updatedDate"));
        this.setDescription(applicationGenericValue.getString("description"));
        if (remoteAddressGenericValue != null) {
            this.setRemoteAddresses(RemoteAddressEntity.toRemoteAddresses(remoteAddressGenericValue));
        } else {
            this.setRemoteAddresses(Collections.emptySet());
        }
    }

    static OfBizApplication from(GenericValue genericValue, List<GenericValue> remoteAddressGenericValue) {
        return new OfBizApplication((GenericValue)Assertions.notNull((Object)genericValue), remoteAddressGenericValue);
    }

    public List<DirectoryMapping> getDirectoryMappings() {
        List directories = this.directoryDao.findAll();
        ArrayList<DirectoryMapping> mappings = new ArrayList<DirectoryMapping>(directories.size());
        for (Directory directory : directories) {
            mappings.add(new DirectoryMapping((Application)this, directory, true, ALLOWED_OPERATIONS));
        }
        return Collections.unmodifiableList(mappings);
    }

    public DirectoryMapping getDirectoryMapping(long directoryId) {
        List directories = this.directoryDao.findAll();
        for (Directory directory : directories) {
            if (!directory.getId().equals(directoryId)) continue;
            return new DirectoryMapping((Application)this, directory, true, ALLOWED_OPERATIONS);
        }
        return null;
    }

    void setDirectoryDao(OfBizDirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }
}

