/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.lucene;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.jira.bc.user.search.UserIndexer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdQueryTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(CrowdQueryTranslator.class);
    private final Analyzer analyzer;

    public CrowdQueryTranslator(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Optional<Query> translateQuery(EntityQuery<?> query) {
        if (query.getMaxResults() == -1) {
            LOG.debug("Refused an unbounded search");
            return Optional.empty();
        }
        return this.translateRestriction(query.getSearchRestriction());
    }

    public Optional<Query> tryQuerying(long directoryId, EntityQuery<?> crowdQuery) {
        return this.translateQuery(crowdQuery).map(query -> {
            TermQuery directoryFilter = new TermQuery(new Term("directory_id", String.valueOf(directoryId)));
            BooleanQuery.Builder usersInDirectory = new BooleanQuery.Builder();
            usersInDirectory.add(query, BooleanClause.Occur.MUST);
            usersInDirectory.add((Query)directoryFilter, BooleanClause.Occur.MUST);
            return usersInDirectory.build();
        });
    }

    private Optional<Query> translateRestriction(@Nullable SearchRestriction restriction) {
        if (restriction == null || restriction instanceof NullRestriction) {
            return Optional.of(new MatchAllDocsQuery());
        }
        if (restriction instanceof BooleanRestriction) {
            return this.translateBoolean((BooleanRestriction)restriction);
        }
        if (restriction instanceof PropertyRestriction) {
            return this.translateProperty((PropertyRestriction)restriction);
        }
        LOG.debug("Unsupported restriction type " + restriction.getClass());
        return Optional.empty();
    }

    private Optional<Query> translateBoolean(BooleanRestriction crowdRestriction) {
        return this.translateOccurrence(crowdRestriction.getBooleanLogic()).flatMap(occurrence -> {
            List<Optional<Query>> restrictions = crowdRestriction.getRestrictions().stream().map(this::translateRestriction).collect(Collectors.toList());
            return this.collapse(restrictions, (BooleanClause.Occur)occurrence);
        });
    }

    private Optional<Query> collapse(List<Optional<Query>> subQueries, BooleanClause.Occur occurrence) {
        if (subQueries.isEmpty()) {
            return Optional.of(new MatchAllDocsQuery());
        }
        if (subQueries.stream().allMatch(Optional::isPresent)) {
            if (subQueries.size() == 1) {
                return subQueries.get(0);
            }
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            subQueries.stream().flatMap(subQuery -> subQuery.isPresent() ? Stream.of(subQuery.get()) : Stream.empty()).forEach(subQuery -> query.add(subQuery, occurrence));
            return Optional.of(query.build());
        }
        LOG.debug("Refusing to collapse subQueries=" + subQueries + " because some of them are absent");
        return Optional.empty();
    }

    private Optional<BooleanClause.Occur> translateOccurrence(BooleanRestriction.BooleanLogic function) {
        switch (function) {
            case AND: {
                return Optional.of(BooleanClause.Occur.MUST);
            }
            case OR: {
                return Optional.of(BooleanClause.Occur.SHOULD);
            }
        }
        LOG.debug("Unsupported boolean function: " + function);
        return Optional.empty();
    }

    private Optional<Query> translateProperty(PropertyRestriction<?> restriction) {
        MatchMode matchMode = restriction.getMatchMode();
        String name = restriction.getProperty().getPropertyName();
        String value = restriction.getValue().toString();
        if (matchMode == MatchMode.EXACTLY_MATCHES) {
            String nameToUse = UserIndexer.exactMatchFieldName(name);
            return this.translateTerm(nameToUse, IdentifierUtils.toLowerCase((String)value), matchMode);
        }
        Analyzer analyzerToUse = this.analyzer;
        String nameToUse = name;
        List<Optional<Query>> tokenizedQueries = this.tokenize(nameToUse, value, analyzerToUse).stream().map(valueToken -> this.translateTerm(nameToUse, (String)valueToken, matchMode)).collect(Collectors.toList());
        return this.collapse(tokenizedQueries, BooleanClause.Occur.MUST);
    }

    private Optional<Query> translateTerm(String name, String value, MatchMode matchMode) {
        switch (matchMode) {
            case STARTS_WITH: {
                return Optional.of(new PrefixQuery(new Term(name, value)));
            }
            case EXACTLY_MATCHES: {
                return Optional.of(new TermQuery(new Term(name, value)));
            }
            case LESS_THAN: {
                return Optional.of(new TermRangeQuery(name, new BytesRef((CharSequence)"*"), new BytesRef((CharSequence)value), false, false));
            }
            case GREATER_THAN: {
                return Optional.of(new TermRangeQuery(name, new BytesRef((CharSequence)value), new BytesRef((CharSequence)"*"), false, false));
            }
            case CONTAINS: {
                LOG.debug("Refused a substring search: name=" + name + ", value=" + value + ", matchMode=" + matchMode);
                return Optional.empty();
            }
        }
        LOG.debug("Unsupported match mode: " + matchMode);
        return Optional.empty();
    }

    private List<String> tokenize(String name, String value, Analyzer analyzer) {
        ImmutableList.Builder tokenListBuilder = ImmutableList.builder();
        try (TokenStream tokenStream = analyzer.tokenStream(name, (Reader)new StringReader(value));){
            tokenStream.reset();
            CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            while (tokenStream.incrementToken()) {
                tokenListBuilder.add((Object)charTermAttribute.toString());
            }
            tokenStream.end();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tokenListBuilder.build();
    }
}

