/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.index.DefaultIndexEngine;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TieredMergePolicy;

public interface IndexWriterConfiguration {
    public static final int RAM_BUFFER_SIZE_MB = 1024;

    public WriterSettings getInteractiveSettings();

    public WriterSettings getBatchSettings();

    public static class PropertiesAdaptor
    implements IndexWriterConfiguration {
        private final ApplicationProperties properties;
        private final WriterSettings batch = new WriterSettings(){

            @Override
            public int getRAMBufferSizeMB() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.batch.maxrambuffermb", (int)Default.BATCH.getRAMBufferSizeMB());
            }

            @Override
            public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
                return DefaultIndexEngine.FlushPolicy.PERIODIC;
            }

            @Override
            public long getCommitFrequency() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.commitfrequency", (int)((int)Default.INTERACTIVE.getCommitFrequency()));
            }

            @Override
            public boolean getReaderPooling() {
                return PropertiesUtil.getBooleanProperty((ApplicationProperties)properties, (String)"jira.index.readerpooling", (boolean)Default.BATCH.getReaderPooling());
            }
        };
        private final WriterSettings interactive = new WriterSettings(){

            @Override
            public int getRAMBufferSizeMB() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.interactive.maxrambuffermb", (int)Default.INTERACTIVE.getRAMBufferSizeMB());
            }

            @Override
            public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
                return DefaultIndexEngine.FlushPolicy.PERIODIC;
            }

            @Override
            public long getCommitFrequency() {
                return PropertiesUtil.getIntProperty((ApplicationProperties)properties, (String)"jira.index.commitfrequency", (int)((int)Default.INTERACTIVE.getCommitFrequency()));
            }

            @Override
            public boolean getReaderPooling() {
                return PropertiesUtil.getBooleanProperty((ApplicationProperties)properties, (String)"jira.index.readerpooling", (boolean)Default.INTERACTIVE.getReaderPooling());
            }
        };

        public PropertiesAdaptor(@Nonnull ApplicationProperties properties) {
            this.properties = (ApplicationProperties)Assertions.notNull((String)"properties", (Object)properties);
        }

        @Override
        public WriterSettings getBatchSettings() {
            return this.batch;
        }

        @Override
        public WriterSettings getInteractiveSettings() {
            return this.interactive;
        }
    }

    public static abstract class WriterSettings {
        public IndexWriterConfig getWriterConfiguration(Analyzer analyser) {
            ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
            TieredMergePolicy mergePolicy = new TieredMergePolicy();
            mergePolicy.setForceMergeDeletesPctAllowed((double)PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.forcemergedeletespctallowed", (int)10));
            mergePolicy.setFloorSegmentMB((double)PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.floorsegmentmb", (int)2));
            mergePolicy.setMaxMergedSegmentMB((double)PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.maxmergedsegmentmb", (int)5120));
            mergePolicy.setMaxMergeAtOnce(PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.maxmergeatonce", (int)10));
            mergePolicy.setMaxMergeAtOnceExplicit(PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.maxmergeatonceexplicit", (int)30));
            mergePolicy.setNoCFSRatio((double)PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.nocfspct", (int)10) / 100.0);
            mergePolicy.setSegmentsPerTier((double)PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.segmentspertier", (int)10));
            mergePolicy.setReclaimDeletesWeight(PropertiesUtil.getDoubleProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.reclaimdeletesweight", (double)2.0));
            mergePolicy.setMaxCFSSegmentSizeMB(PropertiesUtil.getDoubleProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.maxcfssegmentsizemb", (double)Double.POSITIVE_INFINITY));
            IndexWriterConfig luceneConfig = new IndexWriterConfig(analyser);
            luceneConfig.setMergePolicy((MergePolicy)mergePolicy);
            luceneConfig.setRAMBufferSizeMB((double)this.getRAMBufferSizeMB());
            luceneConfig.setReaderPooling(this.getReaderPooling());
            luceneConfig.setUseCompoundFile(PropertiesUtil.getBooleanProperty((ApplicationProperties)applicationProperties, (String)"jira.index.mergepolicy.usecompoundfile", (boolean)false));
            return luceneConfig;
        }

        public abstract int getRAMBufferSizeMB();

        public abstract DefaultIndexEngine.FlushPolicy getFlushPolicy();

        public abstract long getCommitFrequency();

        public abstract boolean getReaderPooling();
    }

    public static final class Default {
        public static final WriterSettings BATCH = new WriterSettings(){

            @Override
            public int getRAMBufferSizeMB() {
                return 1024;
            }

            @Override
            public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
                return DefaultIndexEngine.FlushPolicy.PERIODIC;
            }

            @Override
            public long getCommitFrequency() {
                return 30000L;
            }

            @Override
            public boolean getReaderPooling() {
                return true;
            }
        };
        public static final WriterSettings INTERACTIVE = new WriterSettings(){

            @Override
            public int getRAMBufferSizeMB() {
                return 1024;
            }

            @Override
            public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
                return DefaultIndexEngine.FlushPolicy.PERIODIC;
            }

            @Override
            public long getCommitFrequency() {
                return 30000L;
            }

            @Override
            public boolean getReaderPooling() {
                return true;
            }
        };
    }
}

