/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.config.InstanceFeatureManager;
import com.atlassian.jira.config.feature.FeaturesLoader;
import com.atlassian.jira.config.feature.FeaturesMapHolder;
import com.atlassian.jira.extension.Startable;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultInstanceFeatureManager
implements InstanceFeatureManager,
Startable,
InitializingComponent {
    private final FeaturesMapHolder features;
    private final EventPublisher eventPublisher;

    public DefaultInstanceFeatureManager(FeaturesLoader featuresLoader, EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.features = new FeaturesMapHolder(featuresLoader);
    }

    public Set<String> getEnabledFeatureKeys() {
        return this.features.enabledFeatures();
    }

    public boolean isInstanceFeatureEnabled(String featureKey) {
        return this.features.enabledFeatures().contains(featureKey);
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.eventPublisher.register((Object)this.features);
    }

    public void start() throws Exception {
        this.features.start();
    }
}

