/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database.jdbcurlparser;

import com.atlassian.jira.config.database.jdbcurlparser.DatabaseInstance;
import com.atlassian.jira.config.database.jdbcurlparser.JdbcUrlParser;
import com.atlassian.jira.exception.ParseException;

public class OracleUrlParser
implements JdbcUrlParser {
    @Override
    public String getUrl(String hostname, String port, String instance) {
        if (this.isIPv6AddressWithoutBrackets(hostname = hostname.trim())) {
            hostname = "[" + hostname + "]";
        }
        return "jdbc:oracle:thin:@//" + hostname + ':' + port.trim() + "/" + instance.trim();
    }

    private boolean isIPv6AddressWithoutBrackets(String address) {
        return address.contains(":") && !address.contains("[") && !address.contains("]");
    }

    @Override
    public DatabaseInstance parseUrl(String jdbcUrl) throws ParseException {
        DatabaseInstance connectionProperties = new DatabaseInstance();
        if (!jdbcUrl.startsWith("jdbc:oracle:thin:")) {
            throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. It should start with protocol prefix 'jdbc:oracle:thin:'.");
        }
        String stripped = jdbcUrl.substring("jdbc:oracle:thin:".length());
        String[] split = stripped.split("@", 2);
        if (split.length == 1) {
            throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. Expected to find a '@' before the host name.");
        }
        String props = split[1];
        if (props.startsWith("//")) {
            String[] hostPortSid = (props = props.substring(2)).split("/", 2);
            if (hostPortSid.length == 1) {
                throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. Missing '/' before the SID.");
            }
            connectionProperties.setInstance(hostPortSid[1]);
            int index = hostPortSid[0].lastIndexOf(58);
            if (index > -1) {
                String hostname = hostPortSid[0].substring(0, index);
                String port = hostPortSid[0].substring(index + 1);
                connectionProperties.setHostname(hostname);
                connectionProperties.setPort(port);
            } else {
                connectionProperties.setHostname(hostPortSid[0]);
            }
        } else {
            String[] hostPortSid = props.split(":", 3);
            if (hostPortSid.length == 1) {
                throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. Missing ':' before the SID.");
            }
            if (hostPortSid.length == 2) {
                connectionProperties.setHostname(hostPortSid[0]);
                connectionProperties.setPort("");
                connectionProperties.setInstance(hostPortSid[1]);
            } else {
                connectionProperties.setHostname(hostPortSid[0]);
                connectionProperties.setPort(hostPortSid[1]);
                connectionProperties.setInstance(hostPortSid[2]);
            }
        }
        return connectionProperties;
    }
}

