/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database.jdbcurlparser;

import com.atlassian.jira.config.database.jdbcurlparser.DatabaseInstance;
import com.atlassian.jira.config.database.jdbcurlparser.JdbcUrlParser;
import com.atlassian.jira.exception.ParseException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstractMySqlUrlParser
implements JdbcUrlParser {
    private static final String ADDRESS_FRAGMENT = "address=";
    private static final String MYSQL_KEY_VALUE_MATCH_REGEX = "\\(\\s*(protocol|host|port)\\s*=[a-zA-Z0-9\\s-:.]*\\)";
    private static final Pattern PROP_MATCH_PATTERN = Pattern.compile("\\(\\s*(protocol|host|port)\\s*=[a-zA-Z0-9\\s-:.]*\\)");
    private final String queryJdbcParam;

    AbstractMySqlUrlParser(String queryJdbcParam) {
        this.queryJdbcParam = queryJdbcParam;
    }

    @Override
    public String getUrl(String hostname, String port, String instance) {
        StringBuilder urlBuilder = new StringBuilder("jdbc:mysql://address=(protocol=tcp)");
        urlBuilder.append(String.format("(host=%s)", hostname.trim()));
        if (port.trim().length() > 0) {
            urlBuilder.append(String.format("(port=%s)", port.trim()));
        }
        urlBuilder.append(String.format("/%s", instance.trim()));
        urlBuilder.append(this.queryJdbcParam);
        return urlBuilder.toString();
    }

    @Override
    public DatabaseInstance parseUrl(String jdbcUrl) throws ParseException {
        String stripped = this.stripOffProtocolPrefix(jdbcUrl);
        if (this.isAlternateUrlFormat(stripped)) {
            return this.parseAlternateUrlFormat(stripped);
        }
        return this.parseStandardUrlFormat(stripped);
    }

    private String stripOffProtocolPrefix(String jdbcUrl) throws ParseException {
        if (!jdbcUrl.startsWith("jdbc:mysql://")) {
            throw new ParseException("Unable to parse the MySQL JDBC URL '" + jdbcUrl + "'. The protocol prefix is not recognized.");
        }
        return jdbcUrl.substring("jdbc:mysql://".length());
    }

    private DatabaseInstance parseStandardUrlFormat(String jdbcUrl) {
        DatabaseInstance connectionProperties = new DatabaseInstance();
        String[] hostPort_DatabaseAndProperties = jdbcUrl.split("/", 2);
        String[] hostPort = hostPort_DatabaseAndProperties[0].split(":", 2);
        connectionProperties.setHostname(hostPort[0]);
        if (hostPort.length == 1) {
            connectionProperties.setPort("");
        } else {
            connectionProperties.setPort(hostPort[1]);
        }
        String[] database_Properties = hostPort_DatabaseAndProperties[1].split("\\?", 2);
        connectionProperties.setInstance(database_Properties[0]);
        return connectionProperties;
    }

    private DatabaseInstance parseAlternateUrlFormat(String jdbcUrl) {
        DatabaseInstance dbProperties = new DatabaseInstance();
        String stripped2 = jdbcUrl.substring(ADDRESS_FRAGMENT.length());
        String[] urlParts = stripped2.split("/", 2);
        HashMap<String, String> coreDbProps = new HashMap<String, String>();
        Matcher matcher = PROP_MATCH_PATTERN.matcher(urlParts[0]);
        while (matcher.find()) {
            String pairPart = matcher.group().trim();
            String propPair = pairPart.substring(1, pairPart.length() - 1);
            String[] propValue = propPair.split("=", 2);
            coreDbProps.put(propValue[0].trim().toLowerCase(), propValue[1].trim().toLowerCase());
        }
        dbProperties.setHostname((String)coreDbProps.get("host"));
        dbProperties.setPort(coreDbProps.getOrDefault("port", ""));
        String[] dbProps = urlParts[1].split("\\?", 2);
        dbProperties.setInstance(dbProps[0]);
        return dbProperties;
    }

    private boolean isAlternateUrlFormat(String strippedJdbcUrl) {
        return strippedJdbcUrl.startsWith(ADDRESS_FRAGMENT);
    }
}

