/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.InvalidDatabaseDriverException;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.help.StaticHelpUrls;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;

@Internal
public class DatabaseDriverRegisterer {
    private final DatabaseType databaseType;
    private final String driverClassName;

    public static DatabaseDriverRegisterer forType(DatabaseType type) {
        return new DatabaseDriverRegisterer((DatabaseType)((Object)Assertions.notNull((String)"type", (Object)((Object)type))), type.getJdbcDriverClassName());
    }

    public static DatabaseDriverRegisterer forDriverClass(String className) {
        return new DatabaseDriverRegisterer(DatabaseDriverRegisterer.findForDriverClass((String)Assertions.notNull((String)"driverClassName", (Object)className)), className);
    }

    private static DatabaseType findForDriverClass(String className) {
        return DatabaseType.forJdbcDriverClassName(className).orElse(DatabaseType.UNKNOWN);
    }

    private DatabaseDriverRegisterer(DatabaseType databaseType, String driverClassName) {
        this.databaseType = databaseType;
        this.driverClassName = driverClassName;
    }

    public DatabaseType databaseType() {
        return this.databaseType;
    }

    public void registerDriver() {
        try {
            Class.forName(this.driverClassName);
        }
        catch (ClassNotFoundException ex) {
            Iterator<String> message = this.getErrorMessage().iterator();
            JiraStartupLogger.log().fatal((Object)message.next());
            while (message.hasNext()) {
                JiraStartupLogger.log().info((Object)message.next());
            }
            throw new InvalidDatabaseDriverException(this.driverClassName, "JDBC Driver class '" + this.driverClassName + " could not be loaded.'", ex);
        }
    }

    public Iterable<String> getErrorMessage() {
        HelpUrl link;
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)("Driver for the database " + this.databaseType.getDisplayName() + " not found. Ensure it is installed in the 'lib' directory."));
        if (this.databaseType == DatabaseType.MY_SQL) {
            builder.add((Object)"If you are upgrading a standalone distribution of JIRA, this may be due to the fact that JIRA no longer ships with MySQL drivers.");
        }
        if (this.databaseType == DatabaseType.ORACLE) {
            builder.add((Object)"If you are upgrading a standalone distribution of JIRA, this may be due to the fact that JIRA no longer ships with Oracle drivers.");
        }
        if ((link = this.getDbConfigLink(StaticHelpUrls.getInstance())) != null) {
            builder.add((Object)String.format("Please visit %s for more information.", link.getUrl()));
        }
        return builder.build();
    }

    public boolean isDriverRegistered() {
        try {
            Class.forName(this.driverClassName);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private HelpUrl getDbConfigLink(HelpUrls urls) {
        if (!DatabaseDriverRegisterer.hasDbconfigLink(this.databaseType.getTypeName(), urls)) {
            return null;
        }
        return DatabaseDriverRegisterer.getDbConfigLink(this.databaseType, urls);
    }

    public static HelpUrl getDbConfigLink(DatabaseType type, HelpUrls urls) {
        return DatabaseDriverRegisterer.getDbConfigLink(type.getTypeName(), urls);
    }

    private static HelpUrl getDbConfigLink(String key, HelpUrls urls) {
        return urls.getUrl(DatabaseDriverRegisterer.withDbConfigPrefix(key));
    }

    private static boolean hasDbconfigLink(String key, HelpUrls urls) {
        return urls.getUrlKeys().contains(DatabaseDriverRegisterer.withDbConfigPrefix(key));
    }

    private static String withDbConfigPrefix(String key) {
        return "dbconfig." + key;
    }
}

