/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.bean.SubTaskBeanImpl;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.SequenceIssueLinkComparator;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.CollectionReorderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubTaskManager
implements SubTaskManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultSubTaskManager.class);
    private static final String ISSUE_TYPE_NAME = "IssueType";
    private static final String DEFAULT_SUB_TASK_ISSUE_TYPE_NAME = "Sub-task";
    private static final long DEFAULT_SUB_TASK_ISSUE_TYPE_SEQUENCE = 0L;
    private static final String DEFAULT_SUB_TASK_ISSUE_TYPE_DESCRIPTION = "The sub-task of the issue";
    private static final String DEFAULT_SUB_TASK_ISSUE_TYPE_ICON_URL = "/images/icons/issuetypes/subtask_alternate.png";
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkManager issueLinkManager;
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final ConstantsManager constantsManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final IssueManager issueManager;

    public DefaultSubTaskManager(ConstantsManager constantsManager, IssueLinkTypeManager issueLinkTypeManager, IssueLinkManager issueLinkManager, PermissionManager permissionManager, ApplicationProperties applicationProperties, IssueTypeSchemeManager issueTypeSchemeManager, IssueManager issueManager) {
        this.constantsManager = constantsManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkManager = issueLinkManager;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.issueManager = issueManager;
    }

    public void enableSubTasks() throws CreateException {
        this.enableSubTasks(true);
    }

    public void enableSubTasks(boolean createDefaultIfMissing) throws CreateException {
        Collection subTaskIssueTypes;
        Collection subTaskIssueLinks = this.getSubTaskIssueLinkTypes();
        if (subTaskIssueLinks == null || subTaskIssueLinks.isEmpty()) {
            this.issueLinkTypeManager.createIssueLinkType("jira_subtask_link", "jira_subtask_outward", "jira_subtask_inward", "jira_subtask");
        }
        if (createDefaultIfMissing && ((subTaskIssueTypes = this.constantsManager.getSubTaskIssueTypeObjects()) == null || subTaskIssueTypes.isEmpty())) {
            this.insertSubTaskIssueType(DEFAULT_SUB_TASK_ISSUE_TYPE_NAME, (Long)0L, DEFAULT_SUB_TASK_ISSUE_TYPE_DESCRIPTION, DEFAULT_SUB_TASK_ISSUE_TYPE_ICON_URL);
        }
        this.applicationProperties.setOption("jira.option.allowsubtasks", true);
    }

    public void disableSubTasks() {
        this.applicationProperties.setOption("jira.option.allowsubtasks", false);
    }

    public Collection<IssueType> getSubTaskIssueTypeObjects() {
        return this.constantsManager.getSubTaskIssueTypeObjects();
    }

    public boolean isSubTasksEnabled() {
        return this.applicationProperties.getOption("jira.option.allowsubtasks");
    }

    public IssueType insertSubTaskIssueType(String name, Long sequence, String description, String iconurl) throws CreateException {
        if (this.issueTypeExistsByName(name)) {
            throw new CreateException("Issue Type with name '" + name + "' already exists.");
        }
        IssueType subTaskIssueType = this.constantsManager.insertIssueType(name, sequence, "jira_subtask", description, iconurl);
        this.issueTypeSchemeManager.addOptionToDefault(subTaskIssueType.getId());
        return subTaskIssueType;
    }

    public IssueType insertSubTaskIssueType(String name, Long sequence, String description, Long avatarId) throws CreateException {
        if (this.issueTypeExistsByName(name)) {
            throw new CreateException("Issue Type with name '" + name + "' already exists.");
        }
        IssueType subTaskIssueType = this.constantsManager.insertIssueType(name, sequence, "jira_subtask", description, avatarId);
        this.issueTypeSchemeManager.addOptionToDefault(subTaskIssueType.getId());
        return subTaskIssueType;
    }

    public void updateSubTaskIssueType(String id, String name, Long sequence, String description, String iconurl) throws DataAccessException {
        this.constantsManager.updateIssueType(id, name, sequence, "jira_subtask", description, iconurl);
    }

    public void updateSubTaskIssueType(String id, String name, Long sequence, String description, Long avatarId) throws DataAccessException {
        this.constantsManager.updateIssueType(id, name, sequence, "jira_subtask", description, avatarId);
    }

    private Collection getSubTaskIssueLinkTypes() {
        return this.issueLinkTypeManager.getIssueLinkTypesByStyle("jira_subtask");
    }

    public boolean issueTypeExistsByName(String name) {
        return this.constantsManager.constantExists(ISSUE_TYPE_NAME, name);
    }

    public void moveSubTaskIssueTypeUp(String id) throws DataAccessException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        ArrayList<IssueType> subTasksIssueTypes = new ArrayList<IssueType>(this.constantsManager.getEditableSubTaskIssueTypes());
        IssueType issueType = this.getSubTaskIssueTypeById(id);
        CollectionReorderer.increasePosition(subTasksIssueTypes, issueType);
        this.recalculateSequencesAndStore(subTasksIssueTypes);
    }

    public void moveSubTaskIssueTypeDown(String id) throws DataAccessException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        ArrayList<IssueType> subTasksIssueTypes = new ArrayList<IssueType>(this.constantsManager.getEditableSubTaskIssueTypes());
        IssueType issueType = this.constantsManager.getIssueType(id);
        CollectionReorderer.decreasePosition(subTasksIssueTypes, issueType);
        this.recalculateSequencesAndStore(subTasksIssueTypes);
    }

    public IssueType getSubTaskIssueTypeById(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        IssueType issueType = this.constantsManager.getIssueType(id);
        if (issueType != null && !issueType.isSubTask()) {
            throw new IllegalArgumentException("The issue type with id '" + id + "' is not a sub-task issue type.");
        }
        return issueType;
    }

    public IssueType getSubTaskIssueType(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        IssueType issueType = this.constantsManager.getIssueTypeObject(id);
        if (issueType == null) {
            return null;
        }
        if (issueType.isSubTask()) {
            return issueType;
        }
        throw new IllegalArgumentException("The issue type with id '" + id + "' is not a sub-task issue type.");
    }

    private void recalculateSequencesAndStore(List<IssueType> issueTypes) throws DataAccessException {
        this.constantsManager.recalculateIssueTypeSequencesAndStore(issueTypes);
    }

    public void removeSubTaskIssueType(String name) throws RemoveException {
        IssueType issueType = (IssueType)this.constantsManager.getIssueConstantByName(ISSUE_TYPE_NAME, name);
        if (issueType != null) {
            if (!issueType.isSubTask()) {
                throw new RemoveException("Issue Type with name '" + name + "' is not a sub-task issue type.");
            }
        } else {
            throw new RemoveException("Issue Type with name '" + name + "' does not exist.");
        }
        this.constantsManager.removeIssueType(issueType.getId());
    }

    public boolean issueTypeExistsById(String id) {
        return this.getSubTaskIssueTypeById(id) != null;
    }

    public boolean isSubTask(Issue issue) {
        return this.getParentIssueId(issue) != null;
    }

    @Nullable
    public Long getParentIssueId(GenericValue issue) {
        this.ensureIssueNotNull(issue);
        return this.getParentIssueId(issue.getLong("id"));
    }

    @Nullable
    public Long getParentIssueId(Issue issue) {
        return this.getParentIssueId(issue.getId());
    }

    @Nullable
    public Long getParentIssueId(Long issueId) {
        if (issueId == null) {
            return null;
        }
        List inwardLinks = this.issueLinkManager.getInwardLinks(issueId);
        for (IssueLink inwardLink : inwardLinks) {
            if (!inwardLink.getIssueLinkType().isSubTaskLinkType()) continue;
            return inwardLink.getSourceId();
        }
        return null;
    }

    public SubTaskBean getSubTaskBean(Issue issue, ApplicationUser remoteUser) {
        SubTaskBeanImpl subTaskBean = new SubTaskBeanImpl();
        List<IssueLink> subTaskIssueLinks = this.getSubTaskIssueLinks(issue.getId());
        HashMap<Long, Long> sequenceMapping = new HashMap<Long, Long>(subTaskIssueLinks.size());
        for (IssueLink subTaskIssueLink : subTaskIssueLinks) {
            sequenceMapping.put(subTaskIssueLink.getDestinationId(), subTaskIssueLink.getSequence());
        }
        for (Issue subTaskIssue : this.bulkLoadDestinationIssues(subTaskIssueLinks)) {
            if (subTaskIssue instanceof MutableIssue) {
                ((MutableIssue)subTaskIssue).setParentObject(issue);
            }
            if (!this.permissionManager.hasPermission(10, subTaskIssue, remoteUser)) continue;
            subTaskBean.addSubTask((Long)sequenceMapping.get(subTaskIssue.getId()), subTaskIssue, issue);
        }
        return subTaskBean;
    }

    public void moveSubTask(Issue parentIssue, Long currentSequence, Long sequence) {
        List<IssueLink> subTaskIssueLinks = this.getSubTaskIssueLinks(parentIssue.getId());
        this.issueLinkManager.moveIssueLink(subTaskIssueLinks, currentSequence, sequence);
    }

    public void resetSequences(Issue issue) {
        this.resetSequences(issue.getId());
    }

    private void resetSequences(Long issueId) {
        List<IssueLink> subTaskIssueLinks = this.getSubTaskIssueLinks(issueId);
        this.issueLinkManager.resetSequences(subTaskIssueLinks);
    }

    public Collection<Long> getAllSubTaskIssueIds() {
        IssueLinkType subTaskIssueLinkType = this.getSubTaskIssueLinkType();
        Collection issueLinks = this.issueLinkManager.getIssueLinks(subTaskIssueLinkType.getId());
        HashSet<Long> subTaskIssueIds = new HashSet<Long>();
        for (IssueLink issueLink : issueLinks) {
            subTaskIssueIds.add(issueLink.getDestinationId());
        }
        return subTaskIssueIds;
    }

    private void ensureIssueNotNull(GenericValue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        if (!"Issue".equals(issue.getEntityName())) {
            throw new IllegalArgumentException("The argument must be an issue.");
        }
    }

    public List<IssueLink> getSubTaskIssueLinks(Long issueId) {
        ArrayList<IssueLink> subTasks = new ArrayList<IssueLink>();
        for (IssueLink link : this.issueLinkManager.getOutwardLinks(issueId)) {
            if (!link.getIssueLinkType().isSubTaskLinkType()) continue;
            subTasks.add(link);
        }
        Collections.sort(subTasks, new SequenceIssueLinkComparator());
        return subTasks;
    }

    public Collection<Issue> getSubTaskObjects(Issue parentIssue) {
        return this.bulkLoadDestinationIssues(this.getSubTaskIssueLinks(parentIssue.getId()));
    }

    private Collection<Issue> bulkLoadDestinationIssues(Collection<IssueLink> issuesToLoad) {
        LinkedList subTaskIds = new LinkedList();
        subTaskIds.addAll(issuesToLoad.stream().map(IssueLink::getDestinationId).collect(Collectors.toList()));
        return this.issueManager.getIssueObjects(subTaskIds);
    }

    public void createSubTaskIssueLink(Issue parentIssue, Issue subTaskIssue, ApplicationUser remoteUser) throws CreateException {
        if (parentIssue == null) {
            throw new IllegalArgumentException("Parent Issue cannot be null.");
        }
        if (subTaskIssue == null) {
            throw new IllegalArgumentException("Sub-Task Issue cannot be null.");
        }
        List<IssueLink> subTaskIssueLinks = this.getSubTaskIssueLinks(parentIssue.getId());
        long sequence = subTaskIssueLinks == null ? 0L : (long)subTaskIssueLinks.size();
        this.issueLinkManager.createIssueLink(parentIssue.getId(), subTaskIssue.getId(), this.getSubTaskIssueLinkType().getId(), Long.valueOf(sequence), remoteUser);
    }

    private IssueLinkType getSubTaskIssueLinkType() {
        Collection subTaskIssueLinkTypes = this.getSubTaskIssueLinkTypes();
        if (subTaskIssueLinkTypes != null && !subTaskIssueLinkTypes.isEmpty()) {
            if (subTaskIssueLinkTypes.size() > 1) {
                log.warn("Found '" + subTaskIssueLinkTypes.size() + "' sub-task issue link types. Returning first one.");
            }
            return (IssueLinkType)subTaskIssueLinkTypes.iterator().next();
        }
        return null;
    }

    public IssueUpdateBean changeParent(Issue subTask, Issue newParentIssue, ApplicationUser currentUser) throws RemoveException, CreateException {
        Issue oldParentIssue = subTask.getParentObject();
        List inwardLinks = this.issueLinkManager.getInwardLinks(subTask.getId());
        for (IssueLink issueLink : inwardLinks) {
            if (!issueLink.getIssueLinkType().isSubTaskLinkType()) continue;
            this.issueLinkManager.removeIssueLink(issueLink, currentUser);
        }
        this.createSubTaskIssueLink(newParentIssue, subTask, currentUser);
        this.resetSequences(newParentIssue.getId());
        this.resetSequences(oldParentIssue.getId());
        ChangeItemBean cibParent = new ChangeItemBean("custom", "Parent Issue", oldParentIssue.getKey(), oldParentIssue.getKey(), newParentIssue.getKey(), newParentIssue.getKey());
        GenericValue newSubTask = (GenericValue)subTask.getGenericValue().clone();
        newSubTask.set("security", (Object)newParentIssue.getSecurityLevelId());
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(newSubTask, subTask.getGenericValue(), EventType.ISSUE_UPDATED_ID, currentUser);
        issueUpdateBean.setChangeItems((Collection)EasyList.build((Object)cibParent));
        return issueUpdateBean;
    }
}

