/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.pico.registrar;

import com.atlassian.jira.component.pico.ComponentContainer;
import com.atlassian.jira.component.pico.adapter.KeyedDelegateComponentAdapter;
import com.atlassian.jira.component.pico.osgi.OsgiServiceScope;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.parameters.ComponentParameter;

public class MultipleKeyRegistrant<T> {
    private final List<Pair<Class<? super T>, OsgiServiceScope>> implementing = new ArrayList<Pair<Class<? super T>, OsgiServiceScope>>();
    private final Class<T> concrete;
    private final List<Parameter> parameters = new ArrayList<Parameter>();

    public static <T> MultipleKeyRegistrant<T> registrantFor(@Nonnull Class<T> concrete) {
        return new MultipleKeyRegistrant<T>(concrete);
    }

    private MultipleKeyRegistrant(@Nonnull Class<T> concrete) {
        this.concrete = (Class)Assertions.notNull((String)"concrete", concrete);
    }

    public MultipleKeyRegistrant<T> parameter(Class<?> parameter) {
        this.parameters.add((Parameter)new ComponentParameter(parameter));
        return this;
    }

    public MultipleKeyRegistrant<T> parameters(Class<?> ... parameters) {
        for (Class<?> parameter : parameters) {
            this.parameter(parameter);
        }
        return this;
    }

    public MultipleKeyRegistrant<T> implementing(Class<? super T> interfaceClass) {
        this.implementing(interfaceClass, null);
        return this;
    }

    public MultipleKeyRegistrant<T> implementing(Class<? super T> interfaceClass, OsgiServiceScope desiredScope) {
        this.implementing.add(Pair.nicePairOf(interfaceClass, (Object)((Object)desiredScope)));
        return this;
    }

    public void registerWith(OsgiServiceScope defaultScope, ComponentContainer container) {
        Assertions.stateTrue((String)"must implement some interfaces", (!this.implementing.isEmpty() ? 1 : 0) != 0);
        if (this.parameters.isEmpty()) {
            container.implementation(OsgiServiceScope.INTERNAL, this.concrete, this.concrete);
        } else {
            container.implementation(OsgiServiceScope.INTERNAL, this.concrete, this.concrete, this.parameters.toArray(new Parameter[0]));
        }
        ComponentAdapter adapter = container.getComponentAdapter(this.concrete);
        for (Pair<Class<? super T>, OsgiServiceScope> pair : this.implementing) {
            KeyedDelegateComponentAdapter delegatingAdapter = new KeyedDelegateComponentAdapter((Class)pair.first(), adapter);
            container.component(pair.second() != null ? (OsgiServiceScope)((Object)pair.second()) : defaultScope, (ComponentAdapter)delegatingAdapter);
        }
    }
}

