/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.pico.osgi;

import com.atlassian.application.api.ApplicationManager;
import com.atlassian.jira.component.pico.ComponentContainer;
import com.atlassian.jira.component.pico.osgi.OsgiService;
import com.atlassian.jira.component.pico.osgi.OsgiServiceRegistry;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class JiraHostComponentProvider
implements HostComponentProvider {
    private static final Map<Class, String> HARD_CODED_KEYS = ImmutableMap.of(ApplicationProperties.class, (Object)"salApplicationProperties", I18nHelper.class, (Object)"contextI18nHelper", ApplicationManager.class, (Object)"atlassianApplicationManager");
    private final ComponentContainer componentContainer;
    private final OsgiServiceRegistry registry;

    public JiraHostComponentProvider(ComponentContainer componentContainer, OsgiServiceRegistry registry) {
        this.componentContainer = componentContainer;
        this.registry = Objects.requireNonNull(registry);
    }

    public void provide(ComponentRegistrar registrar) {
        HashSet<String> usedKeys = new HashSet<String>();
        for (OsgiService component : this.registry.getServices(this.componentContainer)) {
            for (Class<?> iface : component.getInterfaces()) {
                String name = JiraHostComponentProvider.extractSpringLikeBeanNameFromInterface(usedKeys, iface);
                registrar.register(new Class[]{iface}).forInstance(component.getInstance()).withName(name);
                usedKeys.add(name);
            }
        }
    }

    @Nonnull
    @VisibleForTesting
    static String extractSpringLikeBeanNameFromInterface(Collection<String> usedKeys, Class<?> interfaceClass) {
        Objects.requireNonNull(interfaceClass);
        String hardCodedKey = HARD_CODED_KEYS.get(interfaceClass);
        if (hardCodedKey != null) {
            return hardCodedKey;
        }
        return JiraHostComponentProvider.generateKey(usedKeys, interfaceClass);
    }

    private static String generateKey(Collection<String> usedKeys, Class<?> interfaceClass) {
        String generatedKey = StringUtils.uncapitalize((String)interfaceClass.getSimpleName());
        Preconditions.checkState((!usedKeys.contains(generatedKey) ? 1 : 0) != 0, (String)"Key '%s' already taken; cannot be used for %s", (Object)generatedKey, (Object)interfaceClass.getName());
        return generatedKey;
    }
}

