/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component.pico;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.pico.PicoContainerFactory;
import com.atlassian.jira.component.pico.adapter.AppPropertiesComponentAdaptor;
import com.atlassian.jira.component.pico.osgi.JiraHostComponentProvider;
import com.atlassian.jira.component.pico.osgi.OsgiServiceRegistry;
import com.atlassian.jira.component.pico.osgi.OsgiServiceScope;
import com.atlassian.jira.component.pico.web.RequestComponentManager;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.osgi.framework.ServiceFactory;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.parameters.ComponentParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ComponentContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentContainer.class);
    private final MutablePicoContainer picoContainer;
    private final OsgiServiceRegistry osgiServiceRegistry;
    private ContainerLevel level;

    @Nullable
    public static <T> T loadComponent(Class<T> componentClass, Collection<Object> dependencies, @Nullable ComponentContainer existingContainer) {
        if (componentClass.isAssignableFrom(Void.class)) {
            return null;
        }
        MutablePicoContainer existingPicoContainer = existingContainer == null ? null : existingContainer.picoContainer;
        MutablePicoContainer tempContainer = PicoContainerFactory.defaultJIRAContainer((PicoContainer)existingPicoContainer);
        for (Object dependency : dependencies) {
            tempContainer.addComponent(dependency);
        }
        tempContainer.addComponent(componentClass);
        return (T)tempContainer.getComponent(componentClass);
    }

    public ComponentContainer(MutablePicoContainer picoContainer, OsgiServiceRegistry osgiServiceRegistry, ContainerLevel level) {
        this.picoContainer = Objects.requireNonNull(picoContainer);
        this.osgiServiceRegistry = Objects.requireNonNull(osgiServiceRegistry);
        this.level = Objects.requireNonNull(level);
    }

    public <T> T loadComponent(Class<T> componentClass, Collection<Object> dependencies) {
        return ComponentContainer.loadComponent(componentClass, dependencies, this);
    }

    public void registerComponent(@Nullable Class<?> interfaceClass, Class<?> componentClass) {
        if (this.picoContainer.getComponentAdapter(interfaceClass) != null) {
            this.picoContainer.removeComponent(interfaceClass);
        }
        if (interfaceClass == null) {
            this.picoContainer.addComponent(componentClass);
        } else {
            this.picoContainer.addComponent(interfaceClass, componentClass, new Parameter[0]);
        }
    }

    void registerEventComponents() {
        EventPublisher eventPublisher = (EventPublisher)this.picoContainer.getComponent(EventPublisher.class);
        if (eventPublisher != null) {
            Set registeredListeners = Sets.newIdentityHashSet();
            for (ComponentAdapter componentAdapter : this.picoContainer.getComponentAdapters()) {
                Object instance;
                Class componentImplClass = componentAdapter.getComponentImplementation();
                if (componentImplClass.getAnnotation(EventComponent.class) == null || !registeredListeners.add(instance = componentAdapter.getComponentInstance((PicoContainer)this.picoContainer, ComponentAdapter.NOTHING.class))) continue;
                eventPublisher.register(instance);
            }
        }
    }

    void unregisterComponent(@Nullable Class<?> interfaceClass, @Nonnull Class<?> componentClass) {
        if (this.picoContainer.getComponentAdapter(interfaceClass) != null) {
            this.picoContainer.removeComponent(interfaceClass);
        }
        this.picoContainer.removeComponent(componentClass);
    }

    public <T> void implementationBasedOnAppProperty(OsgiServiceScope scope, Class<T> interfaceClass, Class<? extends T> enabledClass, Class<? extends T> disabledClass, String appPropertiesKey) {
        this.component(scope, new AppPropertiesComponentAdaptor<T>((PicoContainer)this.picoContainer, interfaceClass, enabledClass, disabledClass, appPropertiesKey));
    }

    public <T> List<T> getComponents(Class<T> type) {
        return this.picoContainer.getComponents(type);
    }

    @Nullable
    public ComponentAdapter getComponentAdapter(Class<?> key) {
        return this.picoContainer.getComponentAdapter(key);
    }

    @Nullable
    public <T> T getComponentInstance(Class<T> key) {
        return (T)this.picoContainer.getComponent(key);
    }

    @Nullable
    public <T> T getComponentInstanceOfType(Class<T> keyOrType) {
        return (T)this.picoContainer.getComponent(keyOrType);
    }

    @VisibleForTesting
    public HostComponentProvider getHostComponentProvider() {
        return new JiraHostComponentProvider(this, this.osgiServiceRegistry);
    }

    void dispose() {
        Lists.newArrayList((Iterable)this.picoContainer.getComponentAdapters()).forEach(adapter -> this.picoContainer.removeComponent(adapter.getComponentKey()));
        this.picoContainer.dispose();
    }

    public void internalInstance(Object instance) {
        this.picoContainer.addComponent(Objects.requireNonNull(instance));
    }

    public void internalInstance(String key, Object instance) {
        this.picoContainer.addComponent((Object)key, instance, new Parameter[0]);
    }

    public <T, S extends T> void instance(OsgiServiceScope scope, Class<T> key, S instance) {
        scope.registerService(key, this.osgiServiceRegistry);
        this.picoContainer.addComponent(key, instance, new Parameter[0]);
    }

    public void internalInstanceOf(Class<?> componentClass) {
        this.picoContainer.addComponent(componentClass);
    }

    public <T> void implementation(OsgiServiceScope scope, Class<? super T> key, Class<T> implementation) {
        scope.registerService(key, this.osgiServiceRegistry);
        this.picoContainer.addComponent(key, implementation, new Parameter[0]);
    }

    public <T> void implementation(OsgiServiceScope scope, Class<? super T> key, Class<T> implementation, Object ... parametersOrKeys) {
        Parameter[] componentParameters = (Parameter[])Arrays.stream(parametersOrKeys).map(paramOrKey -> paramOrKey instanceof Parameter ? (Parameter)paramOrKey : new ComponentParameter(paramOrKey)).toArray(Parameter[]::new);
        this.implementation(scope, key, implementation, componentParameters);
    }

    public <T> void implementation(OsgiServiceScope scope, Class<? super T> key, Class<T> implementation, Parameter[] parameters) {
        scope.registerService(key, this.osgiServiceRegistry);
        this.picoContainer.addComponent(key, implementation, parameters);
    }

    public <T> void implementationViaNoArgConstructor(OsgiServiceScope scope, Class<T> key, Class<? extends T> implementation) {
        scope.registerService(key, this.osgiServiceRegistry);
        this.picoContainer.addComponent(key, implementation, new Parameter[0]);
    }

    public <T> void provideViaFactory(Class<T> serviceInterface, Class<? extends ServiceFactory<T>> osgiFactoryClass) {
        this.osgiServiceRegistry.registerServiceFactory(serviceInterface, osgiFactoryClass);
    }

    public void component(OsgiServiceScope scope, ComponentAdapter componentAdapter) {
        Object componentKey = componentAdapter.getComponentKey();
        if (componentKey instanceof Class) {
            scope.registerService((Class)componentKey, this.osgiServiceRegistry);
        }
        this.picoContainer.addAdapter(componentAdapter);
    }

    void instantiateComponents() {
        this.picoContainer.getComponents();
    }

    @Nonnull
    public ContainerLevel getLevel() {
        return this.level;
    }

    public void setLevel(ContainerLevel newLevel) {
        this.level = Objects.requireNonNull(newLevel);
    }

    <T> Map<String, T> getComponentsOfTypeMap(Class<T> type) {
        return this.picoContainer.getComponentAdapters(type).stream().collect(Collectors.toMap(adapter -> String.valueOf(adapter.getComponentKey()), adapter -> adapter.getComponentInstance((PicoContainer)this.picoContainer, (Type)type)));
    }

    <T> T createRequestScopedComponent(Class<T> componentClass) {
        MutablePicoContainer requestContainer = new RequestComponentManager().getContainer((PicoContainer)this.picoContainer);
        requestContainer.addComponent(componentClass);
        try {
            return (T)requestContainer.getComponent(componentClass);
        }
        catch (RuntimeException re) {
            throw new RuntimeException("Error instantiating " + componentClass.getName(), re);
        }
    }

    @Nullable
    public <T> T getComponent(Class<T> componentClass) {
        return (T)this.picoContainer.getComponent(componentClass);
    }

    public static enum ContainerLevel {
        BOOTSTRAP("BootstrapContainer", false),
        FAILED_STARTUP("Failed Startup Container", true),
        SETUP("Setup Container", true),
        FULL_CONTAINER("JIRAContainer", false);

        private final boolean extendsBootstrap;
        private final String baseName;

        private ContainerLevel(String baseName, boolean extendsBootstrap) {
            this.baseName = Objects.requireNonNull(baseName);
            this.extendsBootstrap = extendsBootstrap;
        }

        @Nonnull
        public String getNewContainerName() {
            Preconditions.checkState((!this.extendsBootstrap ? 1 : 0) != 0, (String)"Cannot create a container with level %s", (Object)((Object)this));
            return this.baseName + '_' + DateTime.now();
        }

        public boolean extendsBootstrap() {
            return this.extendsBootstrap;
        }

        public boolean isFullContainer() {
            return this == FULL_CONTAINER;
        }

        @Nonnull
        public String getName() {
            return this.baseName;
        }
    }
}

