/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.zdu.analytics;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateManager;
import com.atlassian.jira.cluster.zdu.JiraUpgradeApprovedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeCancelledEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFailedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFinishedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeStartedEvent;
import com.atlassian.jira.cluster.zdu.analytics.NodeStartedAnalytics;
import com.atlassian.jira.cluster.zdu.analytics.NodeStoppedAnalytics;
import com.atlassian.jira.cluster.zdu.analytics.UpgradeApprovedAnalytics;
import com.atlassian.jira.cluster.zdu.analytics.UpgradeCancelledAnalytics;
import com.atlassian.jira.cluster.zdu.analytics.UpgradeCompletedAnalytics;
import com.atlassian.jira.cluster.zdu.analytics.UpgradeFailedAnalytics;
import com.atlassian.jira.cluster.zdu.analytics.UpgradeStartedAnalytics;
import com.atlassian.jira.service.services.analytics.start.JiraStartAnalyticEvent;
import com.atlassian.jira.service.services.analytics.stop.JiraStopAnalyticEvent;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.xml.bind.DatatypeConverter;

@EventComponent
public class ClusterUpgradeAnalyticsListener {
    private static final int HASH_ITERATIONS = 1000;
    private static final String SALT_WORD = new String(DatatypeConverter.parseBase64Binary((String)"bN4KQnRrdFv7+Sa+6Ua/vVIKBlw2ki3bp6VlXMd/7KBTxMMaOgjAgXXhOpRQGPqg\nO14FsD/KGw1Ia7TF5o3Y+gCoeZG18eCb/VBL4u5bDFsmGIBJUBU0Yoo5Xm0oua7e\n/yr0wh0Ev1ttPH14CXvl5z4l+UIdKd/irTijLQXcEtdRA/EQRqMvSO1y/j5oEVCo\njekHm1xin0gKOTM7dXXVL5/WwflvmG/YxKhZnKm8hCZHqwrJXsQWV85Kf7ekbTYw\nCjF9W4ftyypbVlq5TZj92W/M1RpNqKoDpI+7yCCJhuHfhFHH16fK7vhud9DMYIXS\ncgJZKredT9Z2IJyT/b5qjU67X0W23W9PblIzeaGATY3ccpdL7PrulDd7Tl3XI1CR\ni1N9CnNi42o/ZSo0ZxJcGvDlvg2VTcLJIXDJ/EKX+rLdwMiUMVw/RyhGu4FFhg+T\nW6CFMH8MFHmI2Ny9Ue7YI/QeD1OvZIVRH+pys6BqHp1ovf7sZdSHEMDU1+PHdf38\nXrPhtkATJ/YSM8nT7DfuiGRQwfSUs6J5WOZZ2BhTzB9wYJSiiRGCrTpOAZ5EARqz\nzzNBApT2mLa92RM4VoTlG1CudnTYLl4av2xGWjtZM0z6B+pzI7BzS8o1850I85+Q\ndbMaeDt6An97VH/xU8u/cfErwXO7HfP3GTKB2VxtyXU="));
    private final EventPublisher eventPublisher;
    private final ClusterUpgradeStateManager clusterUpgradeStateManager;
    private final ClusterManager clusterManager;
    private final BuildUtilsInfo buildUtilsInfo;

    public ClusterUpgradeAnalyticsListener(EventPublisher eventPublisher, ClusterUpgradeStateManager clusterUpgradeStateManager, ClusterManager clusterManager, BuildUtilsInfo buildUtilsInfo) {
        this.eventPublisher = eventPublisher;
        this.clusterUpgradeStateManager = clusterUpgradeStateManager;
        this.clusterManager = clusterManager;
        this.buildUtilsInfo = buildUtilsInfo;
    }

    @EventListener
    public void onNodeStarted(JiraStartAnalyticEvent event) {
        String nodeId = this.clusterManager.getNodeId();
        if (nodeId == null) {
            return;
        }
        NodeStartedAnalytics analytics = new NodeStartedAnalytics(ClusterUpgradeAnalyticsListener.hash(nodeId), this.buildUtilsInfo.getDatabaseBuildNumber(), this.clusterUpgradeStateManager.getClusterBuildInfo().getBuildNumber(), this.clusterUpgradeStateManager.getUpgradeState().name());
        this.eventPublisher.publish((Object)analytics);
    }

    @EventListener
    public void onNodeStopped(JiraStopAnalyticEvent event) {
        String nodeId = this.clusterManager.getNodeId();
        if (nodeId == null) {
            return;
        }
        NodeStoppedAnalytics analytics = new NodeStoppedAnalytics(ClusterUpgradeAnalyticsListener.hash(nodeId), this.buildUtilsInfo.getDatabaseBuildNumber(), this.clusterUpgradeStateManager.getClusterBuildInfo().getBuildNumber(), this.clusterUpgradeStateManager.getUpgradeState().name());
        this.eventPublisher.publish((Object)analytics);
    }

    @EventListener
    public void onUpgradeStarted(JiraUpgradeStartedEvent event) {
        UpgradeStartedAnalytics analytics = new UpgradeStartedAnalytics(this.clusterManager.findLiveNodes().size(), this.clusterUpgradeStateManager.getClusterBuildInfo().getBuildNumber());
        this.eventPublisher.publish((Object)analytics);
    }

    @EventListener
    public void onUpgradeApproved(JiraUpgradeApprovedEvent event) {
        UpgradeApprovedAnalytics analytics = new UpgradeApprovedAnalytics(this.clusterManager.findLiveNodes().size(), event.getFromVersion().getBuildNumber(), event.getToVersion().getBuildNumber());
        this.eventPublisher.publish((Object)analytics);
    }

    @EventListener
    public void onUpgradeFinished(JiraUpgradeFinishedEvent event) {
        UpgradeCompletedAnalytics analytics = new UpgradeCompletedAnalytics(this.clusterManager.findLiveNodes().size(), event.getFromVersion().getBuildNumber(), event.getToVersion().getBuildNumber());
        this.eventPublisher.publish((Object)analytics);
    }

    @EventListener
    public void onUpgradeCancelled(JiraUpgradeCancelledEvent event) {
        UpgradeCancelledAnalytics analytics = new UpgradeCancelledAnalytics(this.clusterManager.findLiveNodes().size(), event.getNodeBuildInfo().getBuildNumber(), this.buildUtilsInfo.getDatabaseBuildNumber());
        this.eventPublisher.publish((Object)analytics);
    }

    @EventListener
    public void onUpgradeFailed(JiraUpgradeFailedEvent event) {
        UpgradeFailedAnalytics analytics = new UpgradeFailedAnalytics(this.clusterManager.findLiveNodes().size(), event.getFromVersion().getBuildNumber(), event.getToVersion().getBuildNumber(), this.buildUtilsInfo.getDatabaseBuildNumber());
        this.eventPublisher.publish((Object)analytics);
    }

    private static String hash(@Nonnull String value) {
        String hash = value + SALT_WORD;
        for (int i = 0; i < 1000; ++i) {
            hash = Hashing.sha256().hashString((CharSequence)hash, StandardCharsets.UTF_8).toString();
        }
        return UUID.nameUUIDFromBytes(hash.getBytes()).toString();
    }
}

