/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.zdu;

import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.cluster.zdu.ClusterUpgradeLifecycleListener;
import com.atlassian.jira.cluster.zdu.ClusterUpgradePluginLoaderFactory;
import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateManager;
import com.atlassian.jira.cluster.zdu.NodeBuildInfo;
import com.atlassian.jira.cluster.zdu.NodeBuildInfoFactory;
import com.atlassian.jira.cluster.zdu.UpgradeState;
import com.atlassian.jira.plugin.freeze.FreezeFileManager;
import com.atlassian.jira.plugin.freeze.FreezeFileManagerFactory;
import com.atlassian.jira.plugin.freeze.FreezeFileScannerFactory;
import com.atlassian.jira.plugin.freeze.SwitchingScanner;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.ScanningPluginLoader;
import com.atlassian.plugin.loaders.classloading.Scanner;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultClusterUpgradePluginLoaderFactory
implements ClusterUpgradePluginLoaderFactory {
    private final EventListenerRegistrar eventListenerRegistrar;
    private final ClusterUpgradeStateManager clusterUpgradeStateManager;
    private final ClusterMessagingService messageHandlerService;
    private final BuildUtilsInfo buildUtilsInfo;
    private final PluginEventManager pluginEventManager;
    private final FreezeFileScannerFactory freezeFileScannerFactory;
    private final FreezeFileManagerFactory freezeFileManagerFactory;
    private final NodeBuildInfoFactory nodeBuildInfoFactory;
    private final Map<FreezeFileManager, ClusterMessageConsumer> messageConsumers = new HashMap<FreezeFileManager, ClusterMessageConsumer>();

    public DefaultClusterUpgradePluginLoaderFactory(EventListenerRegistrar eventListenerRegistrar, ClusterUpgradeStateManager clusterUpgradeStateManager, MessageHandlerService messageHandlerService, BuildUtilsInfo buildUtilsInfo, PluginEventManager pluginEventManager, FreezeFileScannerFactory freezeFileScannerFactory, FreezeFileManagerFactory freezeFileManagerFactory, NodeBuildInfoFactory nodeBuildInfoFactory) {
        this.eventListenerRegistrar = eventListenerRegistrar;
        this.clusterUpgradeStateManager = clusterUpgradeStateManager;
        this.messageHandlerService = messageHandlerService;
        this.buildUtilsInfo = buildUtilsInfo;
        this.pluginEventManager = pluginEventManager;
        this.freezeFileScannerFactory = freezeFileScannerFactory;
        this.freezeFileManagerFactory = freezeFileManagerFactory;
        this.nodeBuildInfoFactory = nodeBuildInfoFactory;
    }

    @Override
    public PluginLoader create(Scanner installedPluginsScanner, File installedPluginsDirectory, File freezeFile, List<PluginFactory> pluginFactories) {
        Scanner freezeFileScanner = this.freezeFileScannerFactory.createScanner(freezeFile);
        SwitchingScanner switchingScanner = new SwitchingScanner(installedPluginsScanner, freezeFileScanner);
        FreezeFileManager freezer = this.freezeFileManagerFactory.create(freezeFile, installedPluginsDirectory);
        switchingScanner.switchTo(this.shouldUseFreezeFile());
        this.eventListenerRegistrar.register((Object)new ClusterUpgradeLifecycleListener(() -> {
            freezer.freeze();
            switchingScanner.switchTo(true);
        }, () -> {
            freezer.unfreeze();
            switchingScanner.switchTo(false);
        }, () -> {
            freezer.removeUnfrozenPlugins();
            freezer.unfreeze();
            switchingScanner.switchTo(false);
        }));
        ClusterMessageConsumer clusterMessageConsumer = (channel, message, senderId) -> switchingScanner.switchTo(this.shouldUseFreezeFile());
        this.messageConsumers.put(freezer, clusterMessageConsumer);
        this.messageHandlerService.registerListener("Upgrade State", clusterMessageConsumer);
        return new ScanningPluginLoader((Scanner)switchingScanner, pluginFactories, this.pluginEventManager);
    }

    private boolean shouldUseFreezeFile() {
        NodeBuildInfo clusterBuildNumber = this.clusterUpgradeStateManager.getClusterBuildInfo();
        NodeBuildInfo applicationBuildNumber = this.nodeBuildInfoFactory.currentApplicationInfo();
        return UpgradeState.STABLE != this.clusterUpgradeStateManager.getUpgradeState() && applicationBuildNumber.equals(clusterBuildNumber);
    }
}

