/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.beehive.db.ClusterNodeHeartbeatService;
import com.atlassian.beehive.db.spi.ClusterNodeHeartBeatDao;
import com.atlassian.core.util.Clock;
import com.atlassian.jira.cluster.lock.HeartbeatJob;
import com.atlassian.jira.cluster.lock.HeartbeatScheduledExecutorFactory;
import com.atlassian.jira.cluster.lock.HeartbeatSettings;
import com.atlassian.jira.extension.Startable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartableClusterNodeHeartbeatService
implements ClusterNodeHeartbeatService,
Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartableClusterNodeHeartbeatService.class);
    private static final long INITIAL_DELAY = 0L;
    private final ClusterNodeHeartBeatDao clusterNodeHeartBeatDao;
    private final HeartbeatScheduledExecutorFactory scheduledExecutorFactory;
    private final HeartbeatJob heartbeatJob;
    private final Clock clock;
    private final HeartbeatSettings settings;
    private boolean initialised;

    public StartableClusterNodeHeartbeatService(ClusterNodeHeartBeatDao clusterNodeHeartBeatDao, HeartbeatScheduledExecutorFactory scheduledExecutorFactory, HeartbeatJob heartbeatJob, Clock clock, HeartbeatSettings settings) {
        this.clusterNodeHeartBeatDao = clusterNodeHeartBeatDao;
        this.scheduledExecutorFactory = scheduledExecutorFactory;
        this.heartbeatJob = heartbeatJob;
        this.clock = clock;
        this.settings = settings;
        this.initialised = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        HeartbeatScheduledExecutorFactory heartbeatScheduledExecutorFactory = this.scheduledExecutorFactory;
        synchronized (heartbeatScheduledExecutorFactory) {
            if (!this.initialised) {
                this.scheduledExecutorFactory.init();
                this.scheduledExecutorFactory.getScheduledExecutorService().scheduleAtFixedRate(this.createHeartbeatJobWrapper(), 0L, this.settings.getHeartbeatDuration().toMillis(), TimeUnit.MILLISECONDS);
                this.initialised = true;
            }
        }
    }

    @Nonnull
    public String getNodeId() {
        return this.clusterNodeHeartBeatDao.getNodeId();
    }

    public boolean isNodeLive(@Nonnull String nodeId) {
        Long lastHeartbeat = this.getLastHeartbeatTime(nodeId);
        if (lastHeartbeat == null) {
            return false;
        }
        long elapsedTime = this.getCurrentTime() - lastHeartbeat;
        return elapsedTime < this.settings.getNodeAliveTimeout().toMillis();
    }

    @Nullable
    public Long getLastHeartbeatTime(@Nonnull String nodeId) {
        return this.clusterNodeHeartBeatDao.getLastHeartbeatTime(nodeId);
    }

    @Nonnull
    public Collection<String> findLiveNodes() {
        return this.findLiveNodes(this.settings.getNodeAliveTimeout().toMillis());
    }

    @Nonnull
    public Collection<String> findLiveNodes(long threshold) {
        return this.clusterNodeHeartBeatDao.findNodesWithHeartbeatsAfter(this.getCurrentTime() - threshold);
    }

    private long getCurrentTime() {
        return this.clock.getCurrentDate().getTime();
    }

    private Runnable createHeartbeatJobWrapper() {
        return () -> {
            try {
                this.heartbeatJob.run();
            }
            catch (Throwable t) {
                LOGGER.error("Unhandled exception occurred in heartbeat service", t);
            }
        };
    }
}

