/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import java.util.ConcurrentModificationException;
import java.util.concurrent.TimeUnit;

public class JiraClusterLockService {
    private static final long WAIT_FOR_LOCK_TIMEOUT = 5L;
    private ClusterLockService clusterLockService;

    public JiraClusterLockService(ClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInClusterLock(Runnable f, String lockName) throws ConcurrentModificationException {
        ClusterLock lock = this.clusterLockService.getLockForName(lockName);
        if (this.tryLockWithoutException(lock)) {
            try {
                f.run();
            }
            finally {
                lock.unlock();
            }
        } else {
            throw new ConcurrentModificationException("Couldn't acquire lock for " + lockName + ", it's possible that someone else was modifying config at the same time");
        }
    }

    private boolean tryLockWithoutException(ClusterLock lock) {
        try {
            return lock.tryLock(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

