/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.beehive.core.ClusterLockStatus;
import com.atlassian.beehive.db.spi.ClusterLockDao;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.exception.DataAccessException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraClusterLockDao
implements ClusterLockDao {
    private static final Logger log = LoggerFactory.getLogger(JiraClusterLockDao.class);
    private static final EntityCondition IS_HELD_BY_ANY_NODE = new EntityExpr("lockedByNode", EntityOperator.NOT_EQUAL, null);
    private final EntityEngine entityEngine;

    public JiraClusterLockDao(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Nonnull
    public List<ClusterLockStatus> getAllHeldClusterLocks() {
        log.debug("Reading all cluster locks held by any node");
        try {
            return Select.from(Entity.CLUSTER_LOCK_STATUS).whereCondition(IS_HELD_BY_ANY_NODE).runWith(this.entityEngine).asList();
        }
        catch (Exception e) {
            throw new DataAccessException("Failed to read status of all cluster locks held by any node", (Throwable)e);
        }
    }

    @Nullable
    public ClusterLockStatus getClusterLockStatusByName(@Nonnull String lockName) {
        log.debug("Reading cluster lock status by name: '{}'", (Object)lockName);
        try {
            ClusterLockStatus status = (ClusterLockStatus)this.entityEngine.selectFrom(Entity.CLUSTER_LOCK_STATUS).whereEqual("lockName", lockName).singleValue();
            if (status != null) {
                log.debug("Read cluster lock status - name: {}, held by: {}, updated: {}", new Object[]{status.getLockName(), status.getLockedByNode(), status.getUpdateTime()});
            } else {
                log.debug("Read cluster lock status - cluster lock '{}' does not exist yet", (Object)lockName);
            }
            return status;
        }
        catch (Exception e) {
            throw new DataAccessException("Failed to read status of cluster lock '" + lockName + "'", (Throwable)e);
        }
    }

    public boolean tryUpdateAcquireLock(@Nonnull String lockName, @Nonnull String nodeId, long updateTime) {
        int rows;
        log.debug("Acquiring cluster lock '{}' by node: {}", (Object)lockName, (Object)nodeId);
        try {
            rows = Update.into(Entity.CLUSTER_LOCK_STATUS).set("lockedByNode", nodeId).set("updateTime", updateTime).whereEqual("lockName", lockName).andEqual("lockedByNode", (String)null).execute(this.entityEngine);
        }
        catch (Exception e) {
            throw new DataAccessException("Failed to acquire cluster lock '" + lockName + "' by node: " + nodeId, (Throwable)e);
        }
        if (rows == 0) {
            log.warn("Node {} tried to obtain cluster lock '{}' but it was already held by another node", (Object)nodeId, (Object)lockName);
            return false;
        }
        if (rows == 1) {
            log.debug("Acquired cluster lock '{}' by node: {}", (Object)lockName, (Object)nodeId);
            return true;
        }
        throw new IllegalStateException("Too many rows updated in JiraClusterLockDao: " + rows + " for lock name: " + lockName);
    }

    public void insertEmptyClusterLock(@Nonnull String lockName, long updateTime) {
        log.debug("Creating new empty cluster lock with name: '{}'", (Object)lockName);
        try {
            this.entityEngine.createValue(Entity.CLUSTER_LOCK_STATUS, new ClusterLockStatus(lockName, null, updateTime));
            log.debug("Created new empty cluster lock with name: '{}'", (Object)lockName);
        }
        catch (DataAccessException e) {
            if (this.getClusterLockStatusByName(lockName) == null) {
                throw new DataAccessException("Failed to create empty cluster lock with name '" + lockName + "'", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new DataAccessException("Failed to create empty cluster lock with name '" + lockName + "'", (Throwable)e);
        }
    }

    public void unlock(@Nonnull String lockName, @Nonnull String nodeId, long updateTime) {
        int rowsUpdated;
        log.debug("Releasing cluster lock '{}' held by node: {}", (Object)lockName, (Object)nodeId);
        try {
            rowsUpdated = Update.into(Entity.CLUSTER_LOCK_STATUS).set("lockedByNode", (String)null).set("updateTime", updateTime).whereEqual("lockName", lockName).andEqual("lockedByNode", nodeId).execute(this.entityEngine);
        }
        catch (Exception e) {
            throw new DataAccessException("Failed to release cluster lock '" + lockName + "' by node: " + nodeId, (Throwable)e);
        }
        if (rowsUpdated == 0) {
            throw new IllegalMonitorStateException("Attempted to unlock '" + lockName + "' but it was not held by this node ('" + nodeId + "').");
        }
        log.debug("Released cluster lock '{}' held by node: {}", (Object)lockName, (Object)nodeId);
    }

    public void deleteLocksHeldByNode(String nodeId) {
        log.debug("Releasing all cluster locks held by node: {}", (Object)nodeId);
        try {
            int rowsUpdated = this.entityEngine.delete(Delete.from(Entity.CLUSTER_LOCK_STATUS).whereEqual("lockedByNode", nodeId));
            log.debug("Released all '{}' cluster locks held by node: {}", (Object)rowsUpdated, (Object)nodeId);
        }
        catch (Exception e) {
            throw new DataAccessException("Failed to release all cluster locks held by node: " + nodeId, (Throwable)e);
        }
    }
}

