/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.jira.config.properties.JiraProperties;
import java.time.Duration;

public class HeartbeatSettings {
    public static final String CLUSTER_HEARTBEAT_ALIVE_TIMEOUT_IN_SECONDS = "jira.cluster.heartbeat.alive.timeout.seconds";
    private static final Duration DEFAULT_ALIVE_TIMEOUT = Duration.ofMinutes(5L);
    private static final Duration DEFAULT_DURATION = Duration.ofMinutes(1L);
    private final Duration nodeAliveTimeout;
    private final Duration heartbeatDuration;

    public HeartbeatSettings(JiraProperties jiraProps) {
        long timeoutSecs = jiraProps.getLong(CLUSTER_HEARTBEAT_ALIVE_TIMEOUT_IN_SECONDS, Long.valueOf(DEFAULT_ALIVE_TIMEOUT.getSeconds()));
        this.nodeAliveTimeout = Duration.ofSeconds(timeoutSecs);
        this.heartbeatDuration = DEFAULT_DURATION;
    }

    public HeartbeatSettings(Duration nodeAliveTimeout, Duration heartbeatDuration) {
        this.nodeAliveTimeout = nodeAliveTimeout;
        this.heartbeatDuration = heartbeatDuration;
    }

    public Duration getNodeAliveTimeout() {
        return this.nodeAliveTimeout;
    }

    public Duration getHeartbeatDuration() {
        return this.heartbeatDuration;
    }
}

