/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.tape;

import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOp;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOpQueue;
import com.atlassian.jira.cluster.distribution.localq.LocalQCriticalHandler;
import com.atlassian.jira.cluster.distribution.localq.tape.TapeLocalQCacheOpConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapeLocalQCriticalHandler
implements LocalQCriticalHandler {
    static final String CORRUPTED_PREFIX = "corrupted_";
    private static final Logger LOG = LoggerFactory.getLogger(TapeLocalQCriticalHandler.class);

    @Override
    public boolean handleCriticalAdd(LocalQCacheOpQueue localQCacheOpQueue, LocalQCacheOp toAdd, Throwable t) {
        return TapeLocalQCriticalHandler.handleClosedQueue(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleNoPermission(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleNotEnoughSpace(localQCacheOpQueue, toAdd, t);
    }

    @Override
    public boolean handleCriticalPeek(LocalQCacheOpQueue localQCacheOpQueue, Throwable t) {
        return TapeLocalQCriticalHandler.handleClosedQueue(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handlePeekProblemByTryingToRemoveFromQueueHead(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleNoPermission(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleFileCorrupted(localQCacheOpQueue, t);
    }

    @Override
    public boolean handleCriticalRemove(LocalQCacheOpQueue localQCacheOpQueue, LocalQCacheOp toRemove, Throwable t) {
        return TapeLocalQCriticalHandler.handleClosedQueue(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleNoPermission(localQCacheOpQueue, t) || TapeLocalQCriticalHandler.handleFileCorrupted(localQCacheOpQueue, t);
    }

    private static boolean handleClosedQueue(LocalQCacheOpQueue queue, Throwable t) {
        if (ExceptionUtils.indexOfType((Throwable)t, IllegalStateException.class) >= 0 && queue.isClosed()) {
            LOG.debug("{} when performing an operation on a closed queue: {}.", new Object[]{t.getClass().getSimpleName(), queue.name(), t});
            return true;
        }
        return false;
    }

    private static boolean handlePeekProblemByTryingToRemoveFromQueueHead(LocalQCacheOpQueue queue, Throwable t) {
        if (ExceptionUtils.indexOfType((Throwable)t, ClassNotFoundException.class) >= 0) {
            LOG.warn("Could not deserialize cache replication event from queue, error: {}. Trying to remove it from queue head: {}. ", new Object[]{t.getMessage(), queue.name(), t});
        }
        try {
            queue.remove();
            LOG.warn("Removed cache replication event from queue head: {}. Note that this may cause the cluster to be out of sync.", (Object)queue.name(), (Object)t);
            return true;
        }
        catch (Throwable anything) {
            return false;
        }
    }

    private static boolean handleNoPermission(LocalQCacheOpQueue queue, Throwable t) {
        if (queue.hasPermission()) {
            return false;
        }
        LOG.error("Jira needs read/write permissions to: {} in order to provide cache replication mechanism. This is a fatal error. Skipping replication. Cluster may be out of sync.", (Object)queue.name());
        return true;
    }

    private static boolean handleNotEnoughSpace(LocalQCacheOpQueue localQCacheOpQueue, LocalQCacheOp localQCacheOp, Throwable t) {
        Long usableSpaceInBytes = localQCacheOpQueue.usableSpaceInBytes();
        Integer estimateObjectSizeInBytes = null;
        Boolean possiblyNotEnoughSpace = null;
        if (usableSpaceInBytes != null && (estimateObjectSizeInBytes = TapeLocalQCriticalHandler.estimateObjectSizeInBytes(localQCacheOp)) != null) {
            possiblyNotEnoughSpace = (long)estimateObjectSizeInBytes.intValue() > usableSpaceInBytes;
        }
        if (possiblyNotEnoughSpace == null) {
            LOG.warn("Unable to determine if enough space left for persisting localQCacheOp, usableSpaceInBytes: {}, estimateObjectSizeInBytes: {}", (Object)usableSpaceInBytes, (Object)estimateObjectSizeInBytes);
            return false;
        }
        if (possiblyNotEnoughSpace.booleanValue()) {
            LOG.error("Not enough space left for persisting localQCacheOp, usableSpaceInBytes: {}, estimateObjectSizeInBytes: {}. Skipping replication of this cache event.", (Object)usableSpaceInBytes, (Object)estimateObjectSizeInBytes);
            return true;
        }
        return false;
    }

    private static Integer estimateObjectSizeInBytes(LocalQCacheOp localQCacheOp) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new TapeLocalQCacheOpConverter().toStream(localQCacheOp, (OutputStream)out);
            return out.size() * 2;
        }
        catch (IOException e) {
            LOG.error("Unable to estimate localQCacheOp size: {}", (Object)localQCacheOp, (Object)e);
            return null;
        }
    }

    private static boolean handleFileCorrupted(LocalQCacheOpQueue queue, Throwable t) {
        if (queue.size() == 0) {
            return true;
        }
        String prefix = CORRUPTED_PREFIX + System.currentTimeMillis() + "_";
        try {
            queue.backupQueue(prefix);
        }
        catch (IOException e) {
            LOG.error("Queue file possibly corrupted, but failed to create a backup for the cache replication queue file: {}, error: {}", new Object[]{queue.name(), e.getMessage(), e});
            return false;
        }
        try {
            TimeUnit.SECONDS.sleep(5L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return true;
    }
}

