/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.tape;

import com.google.common.io.Files;
import com.squareup.tape.FileObjectQueue;
import com.squareup.tape.QueueFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TapeFileObjectQueue {
    private static final Logger LOG = LoggerFactory.getLogger(TapeFileObjectQueue.class);

    TapeFileObjectQueue() {
    }

    static <T> FileObjectQueue<T> create(File file, FileObjectQueue.Converter<T> converter) throws IOException {
        if (!file.exists()) {
            return new FileObjectQueue(file, converter);
        }
        Optional<IOException> ioException = TapeFileObjectQueue.queueFileConstructorThrownException(file);
        if (ioException.isPresent()) {
            LOG.error("Existing cache replication queue file corrupted, trying to backup and continue: file:{}, error:{}", new Object[]{file.getPath(), ioException.get().getMessage(), ioException.get()});
            String prefix = "corrupted_" + System.currentTimeMillis() + "_";
            File backupFile = new File(file.getParent(), prefix + "_" + file.getName());
            if (backupFile.exists()) {
                backupFile.delete();
            }
            Files.move((File)file, (File)backupFile);
            LOG.info("Backup of corrupted cache replication queue created: {}. Note this will not be included in queue stats.", (Object)backupFile.getPath());
            return new FileObjectQueue(file, converter);
        }
        return new FileObjectQueue(file, converter);
    }

    private static Optional<IOException> queueFileConstructorThrownException(File file) {
        try {
            Constructor queueFileConstructor = QueueFile.class.getDeclaredConstructor(RandomAccessFile.class);
            queueFileConstructor.setAccessible(true);
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rwd");){
                QueueFile queueFile = (QueueFile)queueFileConstructor.newInstance(randomAccessFile);
                queueFile.close();
            }
            catch (InvocationTargetException e) {
                int ioExceptionIdx = ExceptionUtils.indexOfType((Throwable)e, IOException.class);
                if (ioExceptionIdx >= 0) {
                    return Optional.of((IOException)ExceptionUtils.getThrowableList((Throwable)e).get(ioExceptionIdx));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }
}

