/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi;

import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOp;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOpSender;
import com.atlassian.jira.cluster.distribution.localq.rmi.RMICachePeerManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalQCacheOpRMISender
implements LocalQCacheOpSender {
    private static final Logger log = LoggerFactory.getLogger(LocalQCacheOpRMISender.class);
    private final ImmutableSet<Class<? extends Throwable>> recoverableExceptions;
    private final ImmutableMap<Class<? extends Throwable>, Integer> retriesByUnrecoverableExceptions;
    private final RMICachePeerManager rmiCachePeerManager;

    public LocalQCacheOpRMISender(RMICachePeerManager rmiCachePeerManager) {
        this.rmiCachePeerManager = rmiCachePeerManager;
        this.recoverableExceptions = ImmutableSet.builder().add(ConnectIOException.class).add(ConnectException.class).build();
        this.retriesByUnrecoverableExceptions = ImmutableMap.builder().put(NotBoundException.class, (Object)2).build();
    }

    boolean isRecoverableException(Throwable t) {
        return this.recoverableExceptions.stream().anyMatch(recoverableException -> recoverableException.isInstance(t));
    }

    private int getRetriesForUnrecoverableException(Throwable t) {
        return this.retriesByUnrecoverableExceptions.entrySet().stream().filter(retryByUnrecoverableException -> ((Class)retryByUnrecoverableException.getKey()).isInstance(t)).findFirst().map(Map.Entry::getValue).orElse(10);
    }

    @Override
    public void send(Node node, LocalQCacheOp localQCacheOp) throws LocalQCacheOpSender.RecoverableFailure, LocalQCacheOpSender.UnrecoverableFailure {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)localQCacheOp);
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            String cacheName = localQCacheOp.getCacheName();
            this.rmiCachePeerManager.withCachePeer(node, cacheName, cachePeer -> {
                try {
                    switch (localQCacheOp.getAction()) {
                        case PUT: {
                            cachePeer.put(new Element(localQCacheOp.getKey(), localQCacheOp.getValue()));
                            break;
                        }
                        case REMOVE: {
                            cachePeer.remove(localQCacheOp.getKey());
                            break;
                        }
                        case REMOVE_ALL: {
                            cachePeer.removeAll();
                        }
                    }
                }
                catch (RemoteException e) {
                    log.trace("Error when calling: {} on cache peer for node: {} and cacheName: {}", new Object[]{localQCacheOp.getAction(), node, cacheName, e});
                    throw e;
                }
            });
            stopwatch.stop();
            log.trace("Send localQCacheOp.action: {} to node: {} in timeInMillis: {}", new Object[]{localQCacheOp.getAction(), node.getNodeId(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        }
        catch (Throwable t) {
            if (this.isRecoverableException(t)) {
                throw new LocalQCacheOpSender.RecoverableFailure(t);
            }
            throw new LocalQCacheOpSender.UnrecoverableFailure(this.getRetriesForUnrecoverableException(t), t);
        }
    }
}

