/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.rmi;

import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.distribution.localq.rmi.RMICachePeerProvider;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.ConfigurableRMIClientSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRMICachePeerProvider
implements RMICachePeerProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BasicRMICachePeerProvider.class);
    private RMIClientSocketFactory rmiClientSocketFactory;

    public BasicRMICachePeerProvider(ClusterNodeProperties clusterNodeProperties) {
        Integer socketTimeoutMillis = BasicRMICachePeerProvider.getSocketTimeoutMillis(clusterNodeProperties);
        LOG.debug("Using RMI client socket factory: {} with socketTimeoutMillis: {}", (Object)ConfigurableRMIClientSocketFactory.class.getSimpleName(), (Object)socketTimeoutMillis);
        this.rmiClientSocketFactory = new ConfigurableRMIClientSocketFactory(socketTimeoutMillis);
    }

    @Override
    public CachePeer create(Node node, String cacheName) throws NotBoundException, RemoteException {
        return this.lookupRemoteCachePeer(node, cacheName);
    }

    private static int getSocketTimeoutMillis(ClusterNodeProperties clusterNodeProperties) {
        String socketTimeoutMillisString = clusterNodeProperties.getProperty("ehcache.listener.socketTimeoutMillis");
        if (socketTimeoutMillisString != null) {
            try {
                return Integer.parseInt(socketTimeoutMillisString);
            }
            catch (NumberFormatException e) {
                LOG.error("Wrong value for ehcache socket timeout listener {} : {}. Using default: {}", new Object[]{"ehcache.listener.socketTimeoutMillis", socketTimeoutMillisString, "5000", e});
            }
        }
        return Integer.parseInt("5000");
    }

    private CachePeer lookupRemoteCachePeer(Node node, String cacheName) throws NotBoundException, RemoteException {
        LOG.debug("Creating cache peer for node: {} and cacheName: {}", (Object)node.getNodeId(), (Object)cacheName);
        Registry registry = LocateRegistry.getRegistry(node.getIp(), node.getCacheListenerPort().intValue(), this.rmiClientSocketFactory);
        return (CachePeer)registry.lookup(cacheName);
    }
}

