/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq;

import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOpQueueWithStats;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class LocalQStatsUtil {
    static void logStats(Logger logger, Set<LocalQCacheOpQueueWithStats> queuesWithStats) {
        Map<String, List<LocalQCacheOpQueueWithStats.QueueStats>> snapshotStatsByNodeId = queuesWithStats.stream().map(LocalQCacheOpQueueWithStats::statsSnapshot).collect(Collectors.groupingBy(queueStats -> queueStats.nodeId));
        Map<String, List<LocalQCacheOpQueueWithStats.QueueStats>> totalStatsByNodeId = queuesWithStats.stream().map(LocalQCacheOpQueueWithStats::statsTotal).collect(Collectors.groupingBy(queueStats -> queueStats.nodeId));
        queuesWithStats.stream().map(queueWithStats -> queueWithStats.id().nodeId).sorted().distinct().forEach(nodeId -> LocalQStatsUtil.logStatsForEachQueuePerNode(logger, nodeId, snapshotStatsByNodeId.getOrDefault(nodeId, Collections.emptyList()), totalStatsByNodeId.getOrDefault(nodeId, Collections.emptyList())));
    }

    private static void logStatsForEachQueuePerNode(Logger logger, String nodeId, List<LocalQCacheOpQueueWithStats.QueueStats> nodeSnapshotStats, List<LocalQCacheOpQueueWithStats.QueueStats> nodeTotalStats) {
        Gson gson = new Gson();
        LocalQCacheOpQueueWithStats.QueueStats nodeSnapshotStatsMerged = LocalQCacheOpQueueWithStats.QueueStats.merge(nodeId, nodeSnapshotStats);
        LocalQCacheOpQueueWithStats.QueueStats nodeTotalStatsMerged = LocalQCacheOpQueueWithStats.QueueStats.merge(nodeId, nodeTotalStats);
        logger.info("Cache replication queue stats per node: {} snapshot stats: {}", (Object)nodeId, (Object)gson.toJson((Object)nodeSnapshotStatsMerged));
        logger.info("Cache replication queue stats per node: {} total stats: {}", (Object)nodeId, (Object)gson.toJson((Object)nodeTotalStatsMerged));
        if (logger.isDebugEnabled()) {
            LocalQStatsUtil.logPerQueue(logger, nodeSnapshotStats, nodeTotalStats);
        }
    }

    private static void logPerQueue(Logger logger, List<LocalQCacheOpQueueWithStats.QueueStats> nodeSnapshotStats, List<LocalQCacheOpQueueWithStats.QueueStats> nodeTotalStats) {
        Gson gson = new Gson();
        nodeSnapshotStats.forEach(queueStats -> logger.debug("Cache replication queue stats per queue, node: {}, nodeQueueNumber: {}, snapshot stats: {}", new Object[]{queueStats.nodeId, queueStats.nodeQueueNumber, gson.toJson(queueStats)}));
        nodeTotalStats.forEach(queueStats -> logger.debug("Cache replication queue stats per queue, node: {}, nodeQueueNumber: {}, total stats: {}", new Object[]{queueStats.nodeId, queueStats.nodeQueueNumber, gson.toJson(queueStats)}));
    }
}

