/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.cluster.EhCacheConfigurationFactory;
import com.atlassian.jira.cluster.distribution.JiraRMICacheManagerPeerProviderFactory;
import com.atlassian.jira.util.JiraUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.distribution.RMICacheManagerPeerListenerFactory;
import org.apache.commons.lang3.Validate;

public class DefaultEhCacheConfigurationFactory
implements EhCacheConfigurationFactory {
    @VisibleForTesting
    public static final String MANAGER_NAME = "JIRA Cache Manager";
    public static final String EHCACHE_MULTICAST_ADDRESS = "ehcache.multicast.address";
    public static final String EHCACHE_MULTICAST_PORT = "ehcache.multicast.port";
    public static final String EHCACHE_MULTICAST_TTL = "ehcache.multicast.timeToLive";
    public static final String EHCACHE_MULTICAST_HOSTNAME = "ehcache.multicast.hostName";
    public static final String EHCACHE_LISTENER_HOSTNAME = "ehcache.listener.hostName";
    public static final String EHCACHE_LISTENER_PORT = "ehcache.listener.port";
    public static final String EHCACHE_OBJECT_PORT = "ehcache.object.port";
    public static final String EHCACHE_LISTENER_SOCKET_TIMEOUT_MILLIS = "ehcache.listener.socketTimeoutMillis";
    public static final String DEFAULT_MULTICAST_ADDRESS = "230.0.0.1";
    public static final String DEFAULT_MULTICAST_PORT = "4446";
    public static final String DEFAULT_LISTENER_PORT = "40001";
    public static final String DEFAULT_OBJECT_PORT = "40011";
    public static final String EHCACHE_PEER_DISCOVERY = "ehcache.peer.discovery";
    public static final String DEFAULT_SOCKET_TIMEOUT_MILLIS = "5000";

    @Override
    public Configuration newConfiguration(@Nonnull URL baseXmlConfiguration, @Nonnull ClusterNodeProperties clusterNodeProperties) {
        Validate.notNull((Object)baseXmlConfiguration, (String)"baseXmlConfiguration", (Object[])new Object[0]);
        Validate.notNull((Object)clusterNodeProperties, (String)"clusterNodeProperties", (Object[])new Object[0]);
        FactoryConfiguration peerListenerFactory = this.buildPeerListenerFactory(clusterNodeProperties);
        FactoryConfiguration peerProviderFactory = this.buildPeerProviderFactory(clusterNodeProperties);
        return ConfigurationFactory.parseConfiguration((URL)baseXmlConfiguration).name(MANAGER_NAME).cacheManagerPeerProviderFactory(peerProviderFactory).cacheManagerPeerListenerFactory(peerListenerFactory);
    }

    private FactoryConfiguration buildPeerListenerFactory(ClusterNodeProperties clusterNodeProperties) {
        Optional<String> hostname = Optional.ofNullable(clusterNodeProperties.getProperty(EHCACHE_LISTENER_HOSTNAME));
        String port = clusterNodeProperties.getProperty(EHCACHE_LISTENER_PORT);
        String objectPort = clusterNodeProperties.getProperty(EHCACHE_OBJECT_PORT);
        String socketTimeoutMillis = clusterNodeProperties.getProperty(EHCACHE_LISTENER_SOCKET_TIMEOUT_MILLIS);
        Properties properties = new Properties();
        properties.put("hostName", this.makeIpv6HostnameEhCacheFriendly(hostname.orElse(JiraUtils.getHostname())));
        properties.put("port", port != null ? port : DEFAULT_LISTENER_PORT);
        properties.put("remoteObjectPort", objectPort != null ? objectPort : DEFAULT_OBJECT_PORT);
        properties.put("socketTimeoutMillis", socketTimeoutMillis != null ? socketTimeoutMillis : DEFAULT_SOCKET_TIMEOUT_MILLIS);
        return new FactoryConfiguration().className(RMICacheManagerPeerListenerFactory.class.getName()).properties(this.propertiesToString(properties));
    }

    private String makeIpv6HostnameEhCacheFriendly(String hostname) {
        return this.isIpv6Address(hostname) ? "[" + hostname + "]" : hostname;
    }

    private boolean isIpv6Address(String hostname) {
        return hostname.contains(":") && !hostname.contains("[");
    }

    private FactoryConfiguration buildPeerProviderFactory(ClusterNodeProperties clusterNodeProperties) {
        String address = clusterNodeProperties.getProperty(EHCACHE_MULTICAST_ADDRESS);
        String port = clusterNodeProperties.getProperty(EHCACHE_MULTICAST_PORT);
        String timeToLive = clusterNodeProperties.getProperty(EHCACHE_MULTICAST_TTL);
        String hostName = clusterNodeProperties.getProperty(EHCACHE_MULTICAST_HOSTNAME);
        String peerDiscovery = clusterNodeProperties.getProperty(EHCACHE_PEER_DISCOVERY);
        String socketTimeoutMillis = clusterNodeProperties.getProperty(EHCACHE_LISTENER_SOCKET_TIMEOUT_MILLIS);
        Properties properties = new Properties();
        if (timeToLive != null) {
            properties.put("timeToLive", timeToLive);
        }
        if (hostName != null) {
            properties.put("hostName", hostName);
        }
        properties.put("peerDiscovery", peerDiscovery != null ? peerDiscovery : "default");
        properties.put("socketTimeoutMillis", socketTimeoutMillis != null ? socketTimeoutMillis : DEFAULT_SOCKET_TIMEOUT_MILLIS);
        properties.put("multicastGroupAddress", address != null ? address : DEFAULT_MULTICAST_ADDRESS);
        properties.put("multicastGroupPort", port != null ? port : DEFAULT_MULTICAST_PORT);
        return new FactoryConfiguration().className(JiraRMICacheManagerPeerProviderFactory.class.getName()).properties(this.propertiesToString(properties));
    }

    private String propertiesToString(Properties properties) {
        StringWriter out = new StringWriter();
        try {
            properties.store(out, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)out).toString();
    }
}

