/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart;

import com.atlassian.jira.charts.jfreechart.ChartGenerator;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.util.ChartDefaults;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import java.awt.Paint;
import java.text.NumberFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class StackedBarChartGenerator
implements ChartGenerator {
    private final CategoryDataset dataset;
    private final String yLabel;
    private I18nBean i18nBean;

    public StackedBarChartGenerator(CategoryDataset dataset, String yLabel, I18nBean I18nBean2) {
        this.dataset = dataset;
        this.yLabel = yLabel;
        this.i18nBean = I18nBean2;
    }

    public ChartHelper generateChart() {
        boolean legend = false;
        boolean tooltips = false;
        boolean urls = false;
        JFreeChart chart = ChartFactory.createStackedBarChart(null, null, (String)this.yLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        StackedBarChartGenerator.setStackedBarChartDefaults(chart, this.i18nBean);
        CategoryPlot plot = chart.getCategoryPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        TickUnitSource units = NumberAxis.createIntegerTickUnits();
        axis.setStandardTickUnits(units);
        CategoryAxis catAxis = plot.getDomainAxis();
        catAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        plot.getRenderer().setSeriesOutlinePaint(1, (Paint)ChartDefaults.GREEN_DIFF);
        plot.getRenderer().setSeriesPaint(1, (Paint)ChartDefaults.GREEN_DIFF);
        plot.getRenderer().setSeriesOutlinePaint(0, (Paint)ChartDefaults.RED_DIFF);
        plot.getRenderer().setSeriesPaint(0, (Paint)ChartDefaults.RED_DIFF);
        return new ChartHelper(chart);
    }

    private static void setStackedBarChartDefaults(JFreeChart chart, I18nBean i18nBean) {
        ChartUtil.setDefaults((JFreeChart)chart, (I18nHelper)i18nBean);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setAxisOffset(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setShadowVisible(false);
        renderer.setBaseItemLabelFont(ChartDefaults.defaultFont);
        renderer.setBaseItemLabelsVisible(false);
        renderer.setItemMargin(0.2);
        renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER));
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setBaseItemLabelPaint((Paint)ChartDefaults.axisLabelColor);
        StandardCategoryToolTipGenerator generator = new StandardCategoryToolTipGenerator("{1}, {2}", NumberFormat.getInstance());
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)generator);
        renderer.setDrawBarOutline(false);
        for (int j = 0; j < ChartDefaults.darkColors.length; ++j) {
            renderer.setSeriesPaint(j, (Paint)ChartDefaults.darkColors[j]);
        }
    }
}

