/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.serialcheck;

import com.atlassian.jira.cache.serialcheck.SerializationRecorder;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSerializationRecorder
implements SerializationRecorder {
    private static final Logger log = LoggerFactory.getLogger(DefaultSerializationRecorder.class);
    private static final Set<Class<?>> KNOWN_SAFE_CLASSES = ImmutableSet.of(String.class);
    private final DataOutputStream recordStream;

    public DefaultSerializationRecorder(Path file) throws IOException {
        this(Files.newOutputStream(file, new OpenOption[0]));
    }

    public DefaultSerializationRecorder(OutputStream recordStream) {
        this.recordStream = new DataOutputStream(recordStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(String cacheName, Object key, Object value) throws IOException {
        if (!this.needsRecord(key) && !this.needsRecord(value)) {
            return;
        }
        log.debug("Recording cache entry " + cacheName + ": " + key + (key != null ? "(" + key.getClass().getName() + ")" : "") + "," + value + (value != null ? "(" + value.getClass().getName() + ")" : ""));
        Object[] record = new Object[]{key, value};
        byte[] recordData = this.serializeToByteArray(record);
        int recordSize = recordData.length;
        DefaultSerializationRecorder defaultSerializationRecorder = this;
        synchronized (defaultSerializationRecorder) {
            this.recordStream.writeInt(recordSize);
            this.recordStream.write(recordData);
            this.recordStream.flush();
        }
    }

    private byte[] serializeToByteArray(Object obj) throws IOException {
        try (ByteArrayOutputStream buf = new ByteArrayOutputStream();){
            try (ObjectOutputStream oos = new ObjectOutputStream(buf);){
                oos.writeObject(obj);
                oos.flush();
            }
            byte[] byArray = buf.toByteArray();
            return byArray;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.recordStream.close();
    }

    protected boolean needsRecord(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> valueType = value.getClass();
        if (valueType.isPrimitive()) {
            return false;
        }
        if (Primitives.isWrapperType(valueType)) {
            return false;
        }
        return !KNOWN_SAFE_CLASSES.contains(valueType);
    }
}

