/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.request.context;

import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.context.RequestCacheContext;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReentrantRequestCacheContext
implements RequestCacheContext {
    private final RequestCacheContext delegate;
    private int nesting = 0;

    public ReentrantRequestCacheContext(RequestCacheContext delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public Map<Object, Object> getLocalMap(RequestCache<?, ?> requestCache) {
        return this.delegate.getLocalMap(requestCache);
    }

    @Override
    @Nullable
    public Map<Object, Object> getLocalMapIfExists(RequestCache<?, ?> requestCache) {
        return this.delegate.getLocalMapIfExists(requestCache);
    }

    @Override
    public void clearAll() {
        this.delegate.clearAll();
    }

    @Override
    public void clearLocalMap(RequestCache<?, ?> requestCache) {
        this.delegate.clearLocalMap(requestCache);
    }

    @Override
    public void open() {
        ++this.nesting;
        this.delegate.open();
    }

    @Override
    public void close() {
        if (this.nesting > 1) {
            --this.nesting;
        } else {
            this.delegate.close();
        }
    }

    @Override
    public void markValueLoading() {
        this.delegate.markValueLoading();
    }
}

