/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.request.context;

import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.context.RequestCacheContext;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MapBasedRequestCacheContext
implements RequestCacheContext {
    private final Supplier<Map<Object, Object>> mapSupplier;
    private final Runnable cleaningCallback;
    private final Map<RequestCache<?, ?>, Map<Object, Object>> mapOfCaches = new IdentityHashMap();

    public MapBasedRequestCacheContext(Supplier<Map<Object, Object>> mapSupplier, Runnable cleaningCallback) {
        this.mapSupplier = mapSupplier;
        this.cleaningCallback = cleaningCallback;
    }

    @Override
    @Nonnull
    public Map<Object, Object> getLocalMap(RequestCache<?, ?> requestCache) {
        return this.mapOfCaches.computeIfAbsent(requestCache, cache -> this.mapSupplier.get());
    }

    @Override
    @Nullable
    public Map<Object, Object> getLocalMapIfExists(RequestCache<?, ?> requestCache) {
        return this.mapOfCaches.get(requestCache);
    }

    @Override
    public void clearAll() {
        this.mapOfCaches.clear();
    }

    @Override
    public void clearLocalMap(RequestCache<?, ?> requestCache) {
        this.mapOfCaches.remove(requestCache);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        this.cleaningCallback.run();
    }

    @Override
    public void markValueLoading() {
    }
}

