/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.request;

import com.atlassian.cache.CacheLoader;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.RequestCacheConfiguration;
import com.atlassian.jira.cache.request.RequestCacheContextFactory;
import com.atlassian.jira.cache.request.RequestCacheImpl;
import com.atlassian.jira.cache.request.context.RequestCacheContext;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.time.Clock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RequestCacheController {
    private static final ThreadLocal<RequestCacheContext> CACHE_CONTEXT_THREAD_LOCAL = new ThreadLocal();
    private static final RequestCacheConfiguration requestCacheConfiguration = new RequestCacheConfiguration(JiraSystemProperties.getInstance().getProperties());
    private static final RequestCacheContextFactory requestCacheContextFactory = new RequestCacheContextFactory(Clock.systemUTC(), requestCacheConfiguration);

    public static void startContext() {
        RequestCacheContext context = RequestCacheController.getContext();
        if (context == null) {
            context = requestCacheContextFactory.createContext(CACHE_CONTEXT_THREAD_LOCAL::remove);
            CACHE_CONTEXT_THREAD_LOCAL.set(context);
        }
        context.open();
    }

    public static void closeContext() {
        RequestCacheContext existing = RequestCacheController.getContext();
        if (existing == null) {
            throw new IllegalStateException("closeContext() without a matching startContext()");
        }
        existing.close();
    }

    public static void clearAll() {
        RequestCacheContext existing = RequestCacheController.getContext();
        if (existing != null) {
            existing.clearAll();
        }
    }

    public static boolean isInContext() {
        return RequestCacheController.getContext() != null;
    }

    @Nullable
    static RequestCacheContext getContext() {
        return CACHE_CONTEXT_THREAD_LOCAL.get();
    }

    public static void process(Runnable runnable) {
        RequestCacheController.startContext();
        try {
            runnable.run();
        }
        finally {
            RequestCacheController.closeContext();
        }
    }

    static <K, V> RequestCache<K, V> createRequestCache(@Nonnull String name, @Nonnull CacheLoader<K, V> cacheLoader) {
        return new RequestCacheImpl<K, V>(name, cacheLoader);
    }
}

