/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.impl.jmx.MBeanRegistrar;
import com.atlassian.jira.cache.DeferredReplicationCache;
import com.atlassian.jira.cache.DeferredReplicationCachedReference;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.management.MBeanServer;

@ParametersAreNonnullByDefault
public class DeferredReplicationCacheManager
implements CacheManager,
MBeanRegistrar {
    private final CacheManager delegate;

    public DeferredReplicationCacheManager(CacheManager delegate) {
        this.delegate = delegate;
    }

    @Deprecated
    @Nonnull
    public Collection<Cache<?, ?>> getCaches() {
        return this.delegate.getCaches();
    }

    @Nonnull
    public Collection<ManagedCache> getManagedCaches() {
        return this.delegate.getManagedCaches();
    }

    public void flushCaches() {
        this.delegate.flushCaches();
    }

    @Nullable
    public ManagedCache getManagedCache(@Nonnull String name) {
        return this.delegate.getManagedCache(name);
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier) {
        return this.wrap(this.delegate.getCachedReference(name, supplier));
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(String name, Supplier<V> supplier, CacheSettings cacheSettings) {
        return this.wrap(this.delegate.getCachedReference(name, supplier, cacheSettings));
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier) {
        return this.wrap(this.delegate.getCachedReference(owningClass, name, supplier));
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier, CacheSettings cacheSettings) {
        return this.wrap(this.delegate.getCachedReference(owningClass, name, supplier, cacheSettings));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name) {
        return this.wrap(this.delegate.getCache(name));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(Class<?> owningClass, String name) {
        return this.wrap(this.delegate.getCache(owningClass, name));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, @Nullable CacheLoader<K, V> cacheLoader) {
        return this.wrap(this.delegate.getCache(name, cacheLoader));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, @Nullable CacheLoader<K, V> cacheLoader, CacheSettings cacheSettings) {
        return this.wrap(this.delegate.getCache(name, cacheLoader, cacheSettings));
    }

    @Deprecated
    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, Class<K> keyClass, Class<V> valueClass) {
        return this.wrap(this.delegate.getCache(name, keyClass, valueClass));
    }

    public void registerMBeans(@Nullable MBeanServer mBeanServer) {
        if (this.delegate instanceof MBeanRegistrar) {
            ((MBeanRegistrar)this.delegate).registerMBeans(mBeanServer);
        }
    }

    public void unregisterMBeans(@Nullable MBeanServer mBeanServer) {
        if (this.delegate instanceof MBeanRegistrar) {
            ((MBeanRegistrar)this.delegate).unregisterMBeans(mBeanServer);
        }
    }

    private <T> CachedReference<T> wrap(CachedReference<T> delegate) {
        return new DeferredReplicationCachedReference<T>(delegate);
    }

    private <K, V> Cache<K, V> wrap(Cache<K, V> delegate) {
        return new DeferredReplicationCache<K, V>(delegate);
    }
}

