/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.cluster.cache.ehcache.BlockingParallelCacheReplicator;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DeferredReplicationCache<K, V>
implements Cache<K, V> {
    private final Cache<K, V> delegate;

    public DeferredReplicationCache(Cache<K, V> delegate) {
        this.delegate = delegate;
    }

    @Nonnull
    public String getName() {
        return this.delegate.getName();
    }

    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    @Nonnull
    public Collection<K> getKeys() {
        return this.delegate.getKeys();
    }

    @Nullable
    public V get(K key) {
        return (V)this.delegate.get(key);
    }

    @Nonnull
    public V get(K key, Supplier<? extends V> supplier) {
        return (V)this.delegate.get(key, supplier);
    }

    public void put(K key, V value) {
        BlockingParallelCacheReplicator.runDeferred(() -> {
            this.delegate.put(key, value);
            return null;
        });
    }

    @Nullable
    public V putIfAbsent(K key, V value) {
        return (V)BlockingParallelCacheReplicator.runDeferred(() -> this.delegate.putIfAbsent(key, value));
    }

    public void remove(K key) {
        BlockingParallelCacheReplicator.runDeferred(() -> {
            this.delegate.remove(key);
            return null;
        });
    }

    public boolean remove(K key, V value) {
        return BlockingParallelCacheReplicator.runDeferred(() -> this.delegate.remove(key, value));
    }

    public void removeAll() {
        BlockingParallelCacheReplicator.runDeferred(() -> {
            this.delegate.removeAll();
            return null;
        });
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return BlockingParallelCacheReplicator.runDeferred(() -> this.delegate.replace(key, oldValue, newValue));
    }

    public void addListener(CacheEntryListener<K, V> listener, boolean includeValues) {
        this.delegate.addListener(listener, includeValues);
    }

    public void removeListener(CacheEntryListener<K, V> cacheEntryListener) {
        this.delegate.removeListener(cacheEntryListener);
    }
}

