/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.board;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.board.Board;
import com.atlassian.jira.board.BoardQueryService;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.query.clause.ChangedClauseImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.history.TerminalHistoryPredicate;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.atlassian.query.order.SortOrder;
import java.util.Optional;

public class BoardQueryServiceImpl
implements BoardQueryService {
    private static final String JQL_PARSE_ERROR = "core.board.data.service.jql.parse.error";
    private final I18nHelper.BeanFactory beanFactory;
    private final SearchService searchService;

    public BoardQueryServiceImpl(I18nHelper.BeanFactory beanFactory, SearchService searchService) {
        this.beanFactory = beanFactory;
        this.searchService = searchService;
    }

    @Override
    public Query getAugmentedQueryForDoneIssues(Query query) {
        return JqlQueryBuilder.newBuilder((Query)query).where().and().addClause(this.incompleteIssuesAndCompleteIssuesWithinLast14Days()).endWhere().orderBy().issueKey(SortOrder.DESC).endOrderBy().buildQuery();
    }

    @Override
    public ServiceOutcome<Query> getBaseQueryForBoard(ApplicationUser user, Board board) {
        SearchService.ParseResult jqlParseResult = this.searchService.parseQuery(user, board.getJql());
        return Optional.ofNullable(jqlParseResult.getQuery()).map(query -> ServiceOutcomeImpl.ok(this.queryWithOnlyStandardIssues((Query)query))).orElse(ServiceOutcomeImpl.error(this.beanFactory.getInstance(user).getText(JQL_PARSE_ERROR), ErrorCollection.Reason.VALIDATION_FAILED));
    }

    private Query queryWithOnlyStandardIssues(Query query) {
        return JqlQueryBuilder.newBuilder((Query)query).where().and().issueTypeIsStandard().endWhere().buildQuery();
    }

    private Clause incompleteIssuesAndCompleteIssuesWithinLast14Days() {
        TerminalHistoryPredicate historyPredicate = new TerminalHistoryPredicate(Operator.DURING, (Operand)new MultiValueOperand(new Operand[]{new SingleValueOperand("-14d"), new FunctionOperand("now")}));
        ChangedClauseImpl statusChangedWithin14Days = new ChangedClauseImpl("status", Operator.CHANGED, historyPredicate);
        Clause nonCompletedIssuesClause = JqlQueryBuilder.newClauseBuilder().statusCategory().notEq("done").buildClause();
        Clause completedIssuesClause = JqlQueryBuilder.newClauseBuilder().statusCategory().eq("done").and().addClause((Clause)statusChangedWithin14Days).buildClause();
        return JqlQueryBuilder.newClauseBuilder().addClause(nonCompletedIssuesClause).or().addClause(completedIssuesClause).buildClause();
    }
}

