/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.projectoperation;

import com.atlassian.jira.bc.project.projectoperation.ProjectOperationManager;
import com.atlassian.jira.plugin.projectoperation.PluggableProjectOperation;
import com.atlassian.jira.plugin.projectoperation.ProjectOperationModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProjectOperationManager
implements ProjectOperationManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectOperationManager.class);
    private final PluginAccessor pluginAccessor;

    public DefaultProjectOperationManager(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public List<PluggableProjectOperation> getVisibleProjectOperations(Project project, ApplicationUser user) {
        ArrayList<PluggableProjectOperation> returnList = new ArrayList<PluggableProjectOperation>();
        ArrayList projectOperationDescriptors = new ArrayList(this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectOperationModuleDescriptor.class));
        Collections.sort(projectOperationDescriptors, ModuleDescriptorComparator.COMPARATOR);
        for (ProjectOperationModuleDescriptor descriptor : projectOperationDescriptors) {
            this.loadProjectOperation(project, user, returnList, descriptor);
        }
        return returnList;
    }

    private void loadProjectOperation(Project project, ApplicationUser user, List<? super PluggableProjectOperation> returnList, ProjectOperationModuleDescriptor descriptor) {
        try {
            PluggableProjectOperation pluggableProjectOperation = (PluggableProjectOperation)descriptor.getModule();
            if (pluggableProjectOperation != null && pluggableProjectOperation.showOperation(project, user)) {
                returnList.add((PluggableProjectOperation)pluggableProjectOperation);
            }
        }
        catch (Exception e) {
            log.error("Error loading project operation " + descriptor.getCompleteKey(), (Throwable)e);
        }
    }
}

