/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.license;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class JiraLicenseServiceImpl
implements JiraLicenseUpdaterService {
    private static final int MIN_LICENSE_VERSION = 2;
    private final JiraLicenseManager licenseManager;
    private final ClusterManager clusterManager;
    private final ApplicationManager applicationManager;
    private final UserManager userManager;
    private final HelpUrls helpUrls;

    public JiraLicenseServiceImpl(@Nonnull JiraLicenseManager licenseManager, @Nonnull ClusterManager clusterManager, @Nonnull ApplicationManager applicationManager, @Nonnull UserManager userManager, @Nonnull HelpUrls helpUrls) {
        this.helpUrls = helpUrls;
        this.licenseManager = (JiraLicenseManager)Assertions.notNull((String)"licenseManager", (Object)licenseManager);
        this.clusterManager = (ClusterManager)Assertions.notNull((String)"clusterManager", (Object)clusterManager);
        this.applicationManager = (ApplicationManager)Assertions.notNull((String)"applicationManager", (Object)applicationManager);
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
    }

    @Nonnull
    public String getServerId() {
        return this.licenseManager.getServerId();
    }

    public JiraLicenseService.ValidationResult validate(@Nonnull I18nHelper i18nHelper, @Nonnull String licenseString) {
        LicenseValidationHelper helper = new LicenseValidationHelper(i18nHelper, this.helpUrls);
        Either errorOrLicenseDetails = helper.decodeLicenseDetails(licenseString, this.licenseManager).flatMap(helper.validateLicenseTypeAndVersion(this.isDataCenterConfigured(), 2));
        int totalUserCount = this.userManager.getTotalUserCount();
        if (errorOrLicenseDetails.isLeft()) {
            OurValidationResult validationResult = new OurValidationResult(totalUserCount, licenseString, null);
            validationResult.addError((String)errorOrLicenseDetails.left().get());
            return validationResult;
        }
        return new OurValidationResult(totalUserCount, licenseString, (LicenseDetails)errorOrLicenseDetails.right().get());
    }

    public JiraLicenseService.ValidationResult validate(@Nonnull ApplicationKey applicationKey, @Nonnull String licenseString, @Nonnull I18nHelper i18nHelper) {
        if (applicationKey == null) {
            OurValidationResult validationResult = new OurValidationResult(this.userManager.getTotalUserCount(), licenseString);
            validationResult.addError(i18nHelper.getText("jira.license.validation.invalid.product.key"));
            return validationResult;
        }
        return this.validate((Set<ApplicationKey>)ImmutableSet.of((Object)applicationKey), licenseString, i18nHelper);
    }

    public JiraLicenseService.ValidationResult validateApplicationLicense(@Nonnull I18nHelper i18nHelper, @Nonnull String licenseString) {
        HashSet appKeys = Sets.newHashSet();
        for (Application application : this.applicationManager.getApplications()) {
            appKeys.add(application.getKey());
        }
        return this.validate(appKeys, licenseString, i18nHelper);
    }

    private JiraLicenseService.ValidationResult validate(@Nonnull Set<ApplicationKey> applicationKeys, @Nonnull String licenseString, @Nonnull I18nHelper i18nHelper) {
        int totalUserCount = this.userManager.getTotalUserCount();
        if (applicationKeys.isEmpty()) {
            OurValidationResult validationResult = new OurValidationResult(totalUserCount, licenseString);
            validationResult.addError(i18nHelper.getText("jira.license.validation.invalid.product.key"));
            return validationResult;
        }
        LicenseValidationHelper helper = new LicenseValidationHelper(i18nHelper, this.helpUrls);
        Either errorOrLicenseDetails = helper.decodeLicenseDetails(licenseString, this.licenseManager).flatMap(helper.validateLicenseTypeAndVersion(this.isDataCenterConfigured(), 2)).flatMap(helper.validateLicenseExpiration()).flatMap(helper.validateLicenseUserLimit(applicationKeys)).flatMap(helper.validateNonStarterNonEvaluationLicenseChange(this.licenseManager.getLicenses())).flatMap(helper.validateMaintenanceForApplications(applicationKeys, this.applicationManager)).flatMap(helper.validateMixLicenses(this.licenseManager.getLicenses(), this.isDataCenterConfigured()));
        if (errorOrLicenseDetails.isLeft()) {
            return new OurValidationResult(totalUserCount, licenseString, null, (String)errorOrLicenseDetails.left().get());
        }
        return new OurValidationResult(totalUserCount, licenseString, (LicenseDetails)errorOrLicenseDetails.right().get());
    }

    public SortedSet<String> getSupportEntitlementNumbers() {
        return this.licenseManager.getSupportEntitlementNumbers();
    }

    @Nonnull
    public Iterable<JiraLicenseService.ValidationResult> validate(I18nHelper i18nHelper) {
        ArrayList<JiraLicenseService.ValidationResult> results = new ArrayList<JiraLicenseService.ValidationResult>();
        for (LicenseDetails license : this.getLicenses()) {
            results.add(this.validate(i18nHelper, license.getLicenseString()));
        }
        return results;
    }

    private boolean isDataCenterConfigured() {
        return this.clusterManager.isClustered();
    }

    public Iterable<JiraLicenseService.ValidationResult> validate(I18nHelper i18n, Iterable<String> licenses) {
        if (Iterables.isEmpty(licenses)) {
            OurValidationResult validationResult = new OurValidationResult(this.userManager.getTotalUserCount(), null, null, i18n.getText("admin.errors.no.license.supplied"));
            return Lists.newArrayList((Object[])new JiraLicenseService.ValidationResult[]{validationResult});
        }
        ArrayList<JiraLicenseService.ValidationResult> results = new ArrayList<JiraLicenseService.ValidationResult>(Iterables.size(licenses));
        for (String license : licenses) {
            results.add(this.validate(i18n, license));
        }
        return results;
    }

    public boolean isLicenseSet() {
        return this.licenseManager.isLicenseSet();
    }

    public LicenseDetails setLicense(JiraLicenseService.ValidationResult validationResult) {
        if (validationResult == null || validationResult.getErrorCollection() == null || validationResult.getErrorCollection().hasAnyErrors()) {
            throw new IllegalStateException("setLicense called with illegal ValidationResult object");
        }
        return this.licenseManager.setLicense(validationResult.getLicenseString());
    }

    public LicenseDetails setLicenseNoEvent(JiraLicenseService.ValidationResult validationResult) {
        if (validationResult == null || validationResult.getErrorCollection() == null || validationResult.getErrorCollection().hasAnyErrors()) {
            throw new IllegalStateException("setLicense called with illegal ValidationResult object");
        }
        return this.licenseManager.clearAndSetLicenseNoEvent(validationResult.getLicenseString());
    }

    public void removeLicenses(Iterable<? extends LicenseDetails> licensesToRemove) {
        this.licenseManager.removeLicenses((Iterable)Lists.newArrayList(licensesToRemove));
    }

    @Nonnull
    public Iterable<LicenseDetails> getLicenses() {
        return this.licenseManager.getLicenses();
    }

    private static final class LicenseValidationHelper {
        private final I18nHelper i18nHelper;
        @Nonnull
        private final HelpUrls helpUrls;

        public static boolean licensesShareAtLeastOneApplication(LicenseDetails license1, LicenseDetails license2) {
            HashSet licenseKeys = new HashSet(license1.getLicensedApplications().getKeys());
            licenseKeys.retainAll(license2.getLicensedApplications().getKeys());
            return !licenseKeys.isEmpty();
        }

        public LicenseValidationHelper(@Nonnull I18nHelper i18nHelper, @Nonnull HelpUrls helpUrls) {
            this.i18nHelper = i18nHelper;
            this.helpUrls = helpUrls;
        }

        public Either<String, LicenseDetails> decodeLicenseDetails(String licenseString, @Nonnull JiraLicenseManager licenseManager) {
            if (StringUtils.isBlank((CharSequence)licenseString)) {
                return Either.left((Object)this.i18nHelper.getText("jira.license.validation.invalid.license.key"));
            }
            try {
                LicenseDetails jiraLicenseDetails = licenseManager.getLicense(licenseString);
                return Either.right((Object)jiraLicenseDetails);
            }
            catch (LicenseException licenseNotDecodable) {
                return Either.left((Object)this.i18nHelper.getText("jira.license.validation.invalid.license.key"));
            }
        }

        public Function<LicenseDetails, Either<String, LicenseDetails>> validateLicenseExpiration() {
            return jiraLicenseDetails -> {
                if (jiraLicenseDetails.isExpired()) {
                    return Either.left((Object)this.i18nHelper.getText("jira.license.validation.expired"));
                }
                return Either.right((Object)jiraLicenseDetails);
            };
        }

        public Function<LicenseDetails, Either<String, LicenseDetails>> validateLicenseTypeAndVersion(boolean isDataCenterConfigured, int minLicenseVersion) {
            return jiraLicenseDetails -> {
                if (isDataCenterConfigured && !jiraLicenseDetails.isDataCenter()) {
                    return Either.left((Object)this.i18nHelper.getText("jira.license.validation.not.datacenter", "<a href=\"" + this.licenseCompatibilityUrl() + "\">", "</a>"));
                }
                if (jiraLicenseDetails.getLicenseVersion() < minLicenseVersion) {
                    return Either.left((Object)this.i18nHelper.getText("setup.error.invalidlicensekey.v1.license.version"));
                }
                return Either.right((Object)jiraLicenseDetails);
            };
        }

        private String licenseCompatibilityUrl() {
            return this.helpUrls.getUrl("license.compatibility").getUrl();
        }

        public Function<LicenseDetails, Either<String, LicenseDetails>> validateLicenseUserLimit(@Nonnull Set<ApplicationKey> applicationsToLicense) {
            return jiraLicenseDetails -> {
                LicensedApplications applicationsInLicense = jiraLicenseDetails.getLicensedApplications();
                Set keysInLicense = applicationsInLicense.getKeys();
                if (keysInLicense.isEmpty()) {
                    return Either.left((Object)this.i18nHelper.getText("jira.license.validation.invalid.license.key"));
                }
                for (ApplicationKey applicationKey : applicationsToLicense) {
                    int licUserLimit;
                    if (!keysInLicense.contains(applicationKey) || (licUserLimit = applicationsInLicense.getUserLimit(applicationKey)) == -1 || licUserLimit >= 1) continue;
                    return Either.left((Object)this.i18nHelper.getText("jira.license.validation.product.user.limit.invalid"));
                }
                return Either.right((Object)jiraLicenseDetails);
            };
        }

        public Function<LicenseDetails, Either<String, LicenseDetails>> validateNonStarterNonEvaluationLicenseChange(@Nonnull Iterable<LicenseDetails> existingLicenses) {
            return jiraLicenseDetails -> {
                if (!jiraLicenseDetails.isStarter() && !jiraLicenseDetails.isEvaluation()) {
                    boolean hasMoreThanOneLicense = false;
                    for (LicenseDetails existingLicense : existingLicenses) {
                        boolean licenseTypesDiffer;
                        if (existingLicense.isStarter() || existingLicense.isEvaluation()) continue;
                        boolean bl = licenseTypesDiffer = existingLicense.isPaidType() != jiraLicenseDetails.isPaidType();
                        if (licenseTypesDiffer && (hasMoreThanOneLicense || !LicenseValidationHelper.licensesShareAtLeastOneApplication(existingLicense, jiraLicenseDetails))) {
                            return Either.left((Object)this.i18nHelper.getText("jira.license.validation.does.not.match.existing.license", jiraLicenseDetails.getLicenseType().name(), existingLicense.getLicenseType().name(), "<a href=\"" + this.licenseCompatibilityUrl() + "\">", "</a>"));
                        }
                        hasMoreThanOneLicense = true;
                    }
                }
                return Either.right((Object)jiraLicenseDetails);
            };
        }

        public Function<LicenseDetails, Either<String, LicenseDetails>> validateMixLicenses(@Nonnull Iterable<LicenseDetails> licenses, boolean isDataCenterConfigured) {
            return jiraLicenseDetails -> {
                boolean wouldEndUpWithMixOfLicenses;
                boolean instanceCurrentlyHasDataCenterLicense = false;
                HashSet existingRoleKeys = Sets.newHashSet();
                for (LicenseDetails existingLicence : licenses) {
                    existingRoleKeys.addAll(existingLicence.getLicensedApplications().getKeys());
                    if (!existingLicence.isDataCenter()) continue;
                    instanceCurrentlyHasDataCenterLicense = true;
                }
                existingRoleKeys.removeAll(jiraLicenseDetails.getLicensedApplications().getKeys());
                boolean newLicenseReplacesAllExistingLicense = existingRoleKeys.isEmpty();
                boolean bl = wouldEndUpWithMixOfLicenses = !newLicenseReplacesAllExistingLicense && instanceCurrentlyHasDataCenterLicense != jiraLicenseDetails.isDataCenter();
                if (wouldEndUpWithMixOfLicenses) {
                    if (isDataCenterConfigured) {
                        return Either.left((Object)this.i18nHelper.getText("jira.license.validation.not.datacenter.mix", "<a href=\"" + this.licenseCompatibilityUrl() + "\">", "</a>"));
                    }
                    return Either.left((Object)this.i18nHelper.getText("jira.license.validation.datacenter.mix", "<a href=\"" + this.licenseCompatibilityUrl() + "\">", "</a>"));
                }
                return Either.right((Object)jiraLicenseDetails);
            };
        }

        public Function<LicenseDetails, Either<String, LicenseDetails>> validateMaintenanceForApplications(@Nonnull Set<ApplicationKey> installedAppKeys, @Nonnull ApplicationManager applicationManager) {
            return jiraLicenseDetails -> {
                for (ApplicationKey appKey : installedAppKeys) {
                    LicenseDetails.LicenseStatusMessage maintenanceMessage;
                    Option application = applicationManager.getApplication(appKey);
                    if (!application.isDefined() || jiraLicenseDetails.isMaintenanceValidForBuildDate(((Application)application.get()).buildDate().toDate()) || !(maintenanceMessage = jiraLicenseDetails.getMaintenanceMessage(this.i18nHelper, ((Application)application.get()).getName())).hasAnyMessages()) continue;
                    return Either.left((Object)maintenanceMessage.getAllMessages("<br/><br/>"));
                }
                return Either.right((Object)jiraLicenseDetails);
            };
        }
    }

    private static final class OurValidationResult
    implements JiraLicenseService.ValidationResult {
        private static final String LICENSE_FIELD = "license";
        private final SimpleErrorCollection errorCollection;
        private final String licenseString;
        private final LicenseDetails licenseDetails;
        private final int totalUserCount;
        private int licenseVersion;

        public OurValidationResult(int totalUserCount, @Nonnull String licenseString) {
            this(totalUserCount, licenseString, null);
        }

        public OurValidationResult(int totalUserCount, @Nonnull String licenseString, @Nullable LicenseDetails license) {
            this.licenseString = (String)Assertions.notNull((Object)licenseString);
            this.licenseDetails = license;
            this.errorCollection = new SimpleErrorCollection();
            this.totalUserCount = totalUserCount;
            if (this.licenseDetails != null) {
                this.licenseVersion = this.licenseDetails.getLicenseVersion();
            }
        }

        public OurValidationResult(int totalUserCount, @Nullable String licenseString, @Nullable LicenseDetails license, String ... errors) {
            if (licenseString == null && errors.length == 0) {
                throw new IllegalArgumentException("License string can only be null if there are validation errors");
            }
            this.licenseDetails = license;
            this.licenseString = licenseString;
            this.errorCollection = new SimpleErrorCollection();
            this.totalUserCount = totalUserCount;
            if (this.licenseDetails != null) {
                this.licenseVersion = this.licenseDetails.getLicenseVersion();
            }
            for (String error : errors) {
                this.addError(error);
            }
        }

        private void addError(String message) {
            this.errorCollection.addError(LICENSE_FIELD, message);
        }

        public ErrorCollection getErrorCollection() {
            SimpleErrorCollection copied = new SimpleErrorCollection();
            copied.addErrorCollection((ErrorCollection)this.errorCollection);
            return copied;
        }

        @Nullable
        public LicenseDetails getLicenseDetails() {
            return this.licenseDetails;
        }

        public String getLicenseString() {
            return this.licenseString;
        }

        @Deprecated
        public int getLicenseVersion() {
            return this.licenseVersion;
        }

        @Deprecated
        public int getTotalUserCount() {
            return this.totalUserCount;
        }
    }
}

