/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.vote;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.vote.VoteHistoryEntry;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DefaultVoteService
implements VoteService {
    private final VoteManager voteManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18nFactory;

    public DefaultVoteService(VoteManager voteManager, I18nHelper.BeanFactory beanFactory, ApplicationProperties applicationProperties, PermissionManager permissionManager, I18nHelper.BeanFactory i18nFactory) {
        this.voteManager = voteManager;
        this.beanFactory = beanFactory;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.i18nFactory = i18nFactory;
    }

    public VoteService.VoteValidationResult validateAddVote(ApplicationUser remoteUser, ApplicationUser voter, Issue issue) {
        Assertions.notNull((String)"voter", (Object)voter);
        Assertions.notNull((String)"issue", (Object)issue);
        return this.validateVoting(remoteUser, voter, issue);
    }

    public int addVote(ApplicationUser remoteUser, VoteService.VoteValidationResult validationResult) {
        Assertions.notNull((String)"remoteUser", (Object)remoteUser);
        Assertions.notNull((String)"validationResult", (Object)validationResult);
        ApplicationUser voter = validationResult.getVoter();
        Issue issue = validationResult.getIssue();
        this.voteManager.addVote(voter, issue);
        return this.voteManager.getVoteCount(issue);
    }

    public VoteService.VoteValidationResult validateRemoveVote(ApplicationUser remoteUser, ApplicationUser voter, Issue issue) {
        Assertions.notNull((String)"voter", (Object)voter);
        Assertions.notNull((String)"issue", (Object)issue);
        return this.validateVoting(remoteUser, voter, issue);
    }

    public int removeVote(ApplicationUser remoteUser, VoteService.VoteValidationResult validationResult) {
        Assertions.notNull((String)"remoteUser", (Object)remoteUser);
        Assertions.notNull((String)"validationResult", (Object)validationResult);
        ApplicationUser voter = validationResult.getVoter();
        Issue issue = validationResult.getIssue();
        this.voteManager.removeVote(voter, issue);
        return this.voteManager.getVoteCount(issue);
    }

    public ServiceOutcome<Collection<ApplicationUser>> viewVoters(Issue issue, ApplicationUser remoteUser) {
        I18nHelper i18n = this.i18nFactory.getInstance(remoteUser);
        if (!this.hasPermissionToViewVoters(issue, remoteUser)) {
            return ServiceOutcomeImpl.error(i18n.getText("voters.no.permission"));
        }
        if (this.voteManager.isVotingEnabled()) {
            List voters = this.voteManager.getVotersFor(issue, i18n.getLocale());
            return ServiceOutcomeImpl.ok(voters);
        }
        return ServiceOutcomeImpl.error(i18n.getText("issue.operations.voting.disabled"));
    }

    public ServiceOutcome<List<VoteHistoryEntry>> getVoterHistory(Issue issue, ApplicationUser remoteUser) {
        I18nHelper i18n = this.i18nFactory.getInstance(remoteUser);
        if (!this.hasPermissionToViewVoters(issue, remoteUser)) {
            return ServiceOutcomeImpl.error(i18n.getText("voters.no.permission"));
        }
        if (this.voteManager.isVotingEnabled()) {
            return ServiceOutcomeImpl.ok(this.voteManager.getVoteHistory(issue));
        }
        return ServiceOutcomeImpl.error(i18n.getText("issue.operations.voting.disabled"));
    }

    private boolean hasPermissionToViewVoters(@Nonnull Issue issue, @Nonnull ApplicationUser remoteUser) {
        return this.permissionManager.hasPermission(ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, issue, remoteUser);
    }

    public boolean isVotingEnabled() {
        return this.voteManager.isVotingEnabled();
    }

    public boolean hasVoted(Issue issue, ApplicationUser user) {
        return this.voteManager.hasVoted(user, issue);
    }

    private VoteService.VoteValidationResult validateVoting(ApplicationUser remoteUser, ApplicationUser voter, Issue issue) {
        String reporterId;
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.beanFactory.getInstance(remoteUser);
        VoteService.VoteValidationResult result = new VoteService.VoteValidationResult((ErrorCollection)errors, voter, issue);
        if (Users.isAnonymous((ApplicationUser)remoteUser) || Users.isAnonymous((ApplicationUser)voter)) {
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.voting.not.loggedin"));
        }
        if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, voter)) {
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.error.vote.issue.permission"));
        }
        if (StringUtils.isNotBlank((CharSequence)(reporterId = issue.getReporterId())) && voter != null && reporterId.equals(ApplicationUsers.getKeyFor(voter))) {
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.novote"));
        }
        if (issue.getResolution() != null) {
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.voting.resolved"));
        }
        if (!this.applicationProperties.getOption("jira.option.voting")) {
            result.getErrorCollection().addErrorMessage(i18n.getText("issue.operations.voting.disabled"));
        }
        return result;
    }
}

