/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.search;

import com.atlassian.jira.bc.issue.search.AbstractIssuePickerSearchProvider;
import com.atlassian.jira.bc.issue.search.IssuePickerSearchService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.LuceneQueryModifier;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import org.apache.commons.lang3.StringUtils;

public class LuceneCurrentSearchIssuePickerSearchProvider
extends AbstractIssuePickerSearchProvider {
    private final JiraAuthenticationContext authenticationContext;
    private final SearchService searchService;

    public LuceneCurrentSearchIssuePickerSearchProvider(JiraAuthenticationContext authenticationContext, IssueFactory issueFactory, SearchProvider searchProvider, ConstantsManager constantsManager, SearchService searchService, LuceneQueryModifier modifier) {
        super(issueFactory, searchProvider, constantsManager, modifier);
        this.authenticationContext = authenticationContext;
        this.searchService = searchService;
    }

    @Override
    protected String getId() {
        return "cs";
    }

    @Override
    protected String getLabelKey() {
        return "jira.ajax.autocomplete.current.search";
    }

    @Override
    protected SearchRequest getRequest(IssuePickerSearchService.IssuePickerParameters issuePickerParams) {
        ApplicationUser user;
        SearchService.ParseResult parseResult;
        if (issuePickerParams.getCurrentJQL() != null && (parseResult = this.searchService.parseQuery(user = this.authenticationContext.getUser(), issuePickerParams.getCurrentJQL())).isValid()) {
            return new SearchRequest((Query)new QueryImpl(parseResult.getQuery().getWhereClause(), null, null));
        }
        return null;
    }

    @Override
    public boolean handlesParameters(ApplicationUser searcher, IssuePickerSearchService.IssuePickerParameters issuePickerParams) {
        return StringUtils.isNotBlank((CharSequence)issuePickerParams.getQuery()) && issuePickerParams.getCurrentJQL() != null;
    }
}

