/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.bc.dataimport.ImportResultStore;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import io.atlassian.util.concurrent.ResettableLazyReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultImportResultStore
implements ImportResultStore,
Startable {
    private static final Logger log = LoggerFactory.getLogger(DefaultImportResultStore.class);
    protected static final String PS_KEY = "admin.import.result";
    protected static final String IMPORT_ERROR_KEY = "import.error";
    protected static final String SPECIFIC_ERROR_MESSAGE_KEY = "specific.error.message";
    private EventPublisher eventPublisher;
    @ClusterSafe(value="This is only used by the studio importer and as it is an import, the database is completely replaced. Only ever written once.")
    private ResettableLazyReference<PropertySet> propertiesReference;

    public DefaultImportResultStore(final JiraPropertySetFactory jiraPropertySetFactory, EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.propertiesReference = new ResettableLazyReference<PropertySet>(){

            protected PropertySet create() throws Exception {
                return jiraPropertySetFactory.buildNoncachingPropertySet(DefaultImportResultStore.PS_KEY, Long.valueOf(0L));
            }
        };
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public synchronized void onClearCache(ClearCacheEvent event) {
        this.propertiesReference.reset();
    }

    @Override
    @ClusterSafe(value="This is only used by the studio importer and as it is an import, the database is completely replaced.")
    public synchronized void storeResult(DataImportService.ImportResult importResult) {
        DataImportService.ImportError importError = importResult.getImportError();
        if (importError != null) {
            log.info("Storing import result with error type: {}", (Object)importError.name());
            ((PropertySet)this.propertiesReference.get()).setString(IMPORT_ERROR_KEY, importError.name());
            String specificErrorMessage = importResult.getSpecificErrorMessage();
            ((PropertySet)this.propertiesReference.get()).setText(SPECIFIC_ERROR_MESSAGE_KEY, specificErrorMessage == null ? "" : specificErrorMessage);
        } else {
            log.warn("Could not store import result.");
        }
    }

    @Override
    @ClusterSafe(value="This is only used by the studio importer and as it is an import, the database is completely replaced.")
    public synchronized DataImportService.ImportResult getLastResult() {
        if (((PropertySet)this.propertiesReference.get()).exists(IMPORT_ERROR_KEY)) {
            String importErrorType = ((PropertySet)this.propertiesReference.get()).getString(IMPORT_ERROR_KEY);
            try {
                DataImportService.ImportError importError = DataImportService.ImportError.valueOf((String)importErrorType);
                String message = ((PropertySet)this.propertiesReference.get()).getText(SPECIFIC_ERROR_MESSAGE_KEY);
                DataImportService.ImportResult.Builder builder = new DataImportService.ImportResult.Builder(null);
                builder.setSpecificError(importError, message);
                log.info("Retrieved last import result. It has error type: {}", (Object)importErrorType);
                return builder.build();
            }
            catch (IllegalArgumentException e) {
                log.warn("An unrecognized error type was stored, clearing it: {}", (Object)importErrorType);
                this.clear();
            }
        }
        log.info("No import result retrieved.");
        return null;
    }

    @Override
    @ClusterSafe(value="This is only used by the studio importer and as it is an import, the database is completely replaced.")
    public synchronized void clear() {
        log.info("Clearing last import result.");
        if (((PropertySet)this.propertiesReference.get()).exists(IMPORT_ERROR_KEY)) {
            ((PropertySet)this.propertiesReference.get()).remove(IMPORT_ERROR_KEY);
        }
        if (((PropertySet)this.propertiesReference.get()).exists(SPECIFIC_ERROR_MESSAGE_KEY)) {
            ((PropertySet)this.propertiesReference.get()).remove(SPECIFIC_ERROR_MESSAGE_KEY);
        }
    }
}

