/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationConfigurationHelper;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.propertyset.CachingOfBizPropertyEntryStore;
import com.atlassian.jira.upgrade.ConsistencyChecker;
import com.atlassian.jira.upgrade.ConsistencyCheckerImpl;
import com.atlassian.jira.upgrade.DataImportUpgradeService;
import com.atlassian.jira.upgrade.FirstDataImportUpgradeService;
import com.atlassian.jira.upgrade.UpgradeService;
import com.atlassian.jira.user.util.RecoveryAdminMapper;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.sal.api.upgrade.PluginUpgradeManager;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataImportProductionDependencies {
    private static final Logger log = LoggerFactory.getLogger(DataImportProductionDependencies.class);

    IndexLifecycleManager getIndexLifecycleManager() {
        return (IndexLifecycleManager)ComponentAccessor.getComponentOfType(IndexLifecycleManager.class);
    }

    ConsistencyChecker getConsistencyChecker() {
        return ConsistencyCheckerImpl.getInstance((JohnsonProvider)ComponentAccessor.getComponent(JohnsonProvider.class));
    }

    UpgradeService getUpgradeService(boolean setupMode) {
        if (setupMode) {
            return (UpgradeService)ComponentAccessor.getComponentOfType(FirstDataImportUpgradeService.class);
        }
        return (UpgradeService)ComponentAccessor.getComponentOfType(DataImportUpgradeService.class);
    }

    LifecycleAwareSchedulerService getSchedulerService() {
        return (LifecycleAwareSchedulerService)ComponentAccessor.getComponent(LifecycleAwareSchedulerService.class);
    }

    PluginEventManager getPluginEventManager() {
        return ComponentAccessor.getPluginEventManager();
    }

    PluginUpgradeManager getPluginUpgradeManager() {
        return (PluginUpgradeManager)ComponentAccessor.getOSGiComponentInstanceOfType(PluginUpgradeManager.class);
    }

    ApplicationConfigurationHelper getApplicationConfigurationHelper() {
        return (ApplicationConfigurationHelper)ComponentAccessor.getComponent(ApplicationConfigurationHelper.class);
    }

    MailSettings getMailSettings() {
        return (MailSettings)ComponentAccessor.getComponent(MailSettings.class);
    }

    FeatureManager getFeatureManager() {
        return (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
    }

    void globalRefresh(boolean quickImport) {
        if (quickImport) {
            log.warn("QuickImport is on, doing a fast refresh.");
            PluginPersistentStateStore pluginPersistentStateStore = (PluginPersistentStateStore)ComponentAccessor.getComponentOfType(PluginPersistentStateStore.class);
            PluginPersistentState oldState = pluginPersistentStateStore.load();
            ((CachingOfBizPropertyEntryStore)ComponentAccessor.getComponentOfType(CachingOfBizPropertyEntryStore.class)).refreshAll();
            ((EventPublisher)ComponentAccessor.getComponentOfType(EventPublisher.class)).publish((Object)new XMLRestoreFinishedEvent((Object)this));
            ((EventPublisher)ComponentAccessor.getComponentOfType(EventPublisher.class)).publish((Object)ClearCacheEvent.INSTANCE);
            this.syncPluginStateWithNewData(pluginPersistentStateStore, oldState);
            this.clearStatics();
        } else {
            ComponentManager.getInstance().restart();
        }
    }

    private void syncPluginStateWithNewData(PluginPersistentStateStore pluginPersistentStateStore, PluginPersistentState oldState) {
        HashSet pluginsToEnable = Sets.newHashSet();
        HashSet pluginModulesToEnable = Sets.newHashSet();
        HashSet pluginModulesToDisable = Sets.newHashSet();
        PluginPersistentState newState = pluginPersistentStateStore.load();
        PluginAccessor pluginAccessor = ComponentAccessor.getPluginAccessor();
        PluginController pluginController = ComponentAccessor.getPluginController();
        Collection plugins = pluginAccessor.getPlugins();
        for (Plugin plugin : plugins) {
            boolean enabledInOldSystem = oldState.isEnabled(plugin);
            boolean enabledInNewSystem = newState.isEnabled(plugin);
            if (!enabledInOldSystem && enabledInNewSystem) {
                pluginsToEnable.add(plugin.getKey());
            } else if (enabledInOldSystem && !enabledInNewSystem) {
                pluginController.disablePlugin(plugin.getKey());
            }
            Collection moduleDescriptors = plugin.getModuleDescriptors();
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                boolean moduleEnabledInOldSystem = oldState.isEnabled(moduleDescriptor);
                boolean moduleEnabledInNewSystem = newState.isEnabled(moduleDescriptor);
                if (!moduleEnabledInOldSystem && moduleEnabledInNewSystem) {
                    pluginModulesToEnable.add(moduleDescriptor.getCompleteKey());
                    continue;
                }
                if (!moduleEnabledInOldSystem || moduleEnabledInNewSystem) continue;
                pluginModulesToDisable.add(moduleDescriptor.getCompleteKey());
            }
        }
        pluginController.enablePlugins(pluginsToEnable.toArray(new String[pluginsToEnable.size()]));
        for (String moduleToDisable : pluginModulesToDisable) {
            pluginController.disablePluginModule(moduleToDisable);
        }
        for (String moduleToEnable : pluginModulesToEnable) {
            pluginController.enablePluginModule(moduleToEnable);
        }
    }

    private void clearStatics() {
        JiraKeyUtils.resetKeyMatcher();
    }

    void refreshSequencer() {
        ComponentAccessor.getOfBizDelegator().refreshSequencer();
    }

    void addRecoveryMapping() {
        new RecoveryAdminMapper().map();
    }
}

