/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.WorkflowEventHandler;
import com.atlassian.jira.event.DraftWorkflowPublishedEvent;
import com.atlassian.jira.event.WorkflowCopiedEvent;
import com.atlassian.jira.event.WorkflowCreatedEvent;
import com.atlassian.jira.event.WorkflowDeletedEvent;
import com.atlassian.jira.event.WorkflowRenamedEvent;
import com.atlassian.jira.event.WorkflowUpdatedEvent;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WorkflowEventHandlerImpl
implements WorkflowEventHandler {
    @Override
    public RecordRequest onWorkflowCreatedEvent(WorkflowCreatedEvent event) {
        return this.workflowCreated(event.getWorkflow());
    }

    @Override
    public RecordRequest onWorkflowCopiedEvent(WorkflowCopiedEvent event) {
        return this.workflowCreated(event.getNewWorkflow());
    }

    @Override
    public Option<RecordRequest> onWorkflowUpdatedEvent(WorkflowUpdatedEvent event) {
        if (event.getWorkflow().isDraftWorkflow()) {
            return Option.none();
        }
        return Option.some((Object)this.workflowUpdated(event.getOriginalWorkflow(), event.getWorkflow()));
    }

    @Override
    public RecordRequest onDraftWorkflowPublishedEvent(DraftWorkflowPublishedEvent event) {
        return this.workflowUpdated(event.getOriginalWorkflow(), event.getWorkflow());
    }

    @Override
    public RecordRequest onWorkflowRenamedEvent(WorkflowRenamedEvent event) {
        return new RecordRequest(AuditingCategory.WORKFLOWS, "jira.auditing.workflow.renamed").forObject(AssociatedItem.Type.WORKFLOW, event.getNewWorkflowName(), event.getNewWorkflowName()).withChangedValues(new ChangedValuesBuilder().addIfDifferent("common.words.name", event.getOldWorkflowName(), event.getNewWorkflowName()).build());
    }

    @Override
    public RecordRequest onWorkflowDeletedEvent(WorkflowDeletedEvent event) {
        return new RecordRequest(AuditingCategory.WORKFLOWS, "jira.auditing.workflow.deleted").forObject(AssociatedItem.Type.WORKFLOW, event.getWorkflow().getDisplayName(), event.getWorkflow().getName());
    }

    private RecordRequest workflowCreated(JiraWorkflow workflow) {
        return new RecordRequest(AuditingCategory.WORKFLOWS, "jira.auditing.workflow.created").forObject(AssociatedItem.Type.WORKFLOW, workflow.getDisplayName(), workflow.getName()).withChangedValues(this.computeChangedValues(workflow));
    }

    private RecordRequest workflowUpdated(JiraWorkflow fromWorkflow, JiraWorkflow toWorkflow) {
        return new RecordRequest(AuditingCategory.WORKFLOWS, "jira.auditing.workflow.updated").forObject(AssociatedItem.Type.WORKFLOW, toWorkflow.getDisplayName(), toWorkflow.getName()).withChangedValues(this.computeChangedValues(fromWorkflow, toWorkflow));
    }

    private ImmutableList<ChangedValue> computeChangedValues(JiraWorkflow currentWorkflow) {
        return this.computeChangedValues(null, currentWorkflow);
    }

    private ImmutableList<ChangedValue> computeChangedValues(JiraWorkflow originalWorkflow, JiraWorkflow currentWorkflow) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.words.name", originalWorkflow == null ? null : originalWorkflow.getDisplayName(), currentWorkflow.getDisplayName()).addIfDifferent("common.words.description", originalWorkflow == null ? null : originalWorkflow.getDescription(), currentWorkflow.getDescription());
        this.diffSet(changedValues, "common.words.status", this.getLinkedStatuses(originalWorkflow), this.getLinkedStatuses(currentWorkflow));
        this.diffSet(changedValues, "admin.workflowtransition.transition", this.getActions(originalWorkflow), this.getActions(currentWorkflow));
        return changedValues.build();
    }

    private void diffSet(ChangedValuesBuilder changedValues, String name, Set<ChangeItem> oldList, Set<ChangeItem> newList) {
        Sets.difference(oldList, newList).forEach(removedStatus -> changedValues.add(name, removedStatus.name, null));
        Sets.difference(newList, oldList).forEach(addedStatus -> changedValues.add(name, null, addedStatus.name));
        Sets.intersection(newList, oldList).forEach(addedStatus -> {
            String oldName = oldList.stream().filter(addedStatus::equals).findFirst().map(item -> item.name).orElse(null);
            changedValues.addIfDifferent(name, oldName, addedStatus.name);
        });
    }

    private Set<ChangeItem> getLinkedStatuses(JiraWorkflow workflow) {
        return (Set)Optional.ofNullable(workflow).map(JiraWorkflow::getLinkedStatusObjects).orElse((List)ImmutableList.of()).stream().map(status -> {
            Optional<String> stepName = this.findStatusName(workflow, step -> status.getId().equals(step.getMetaAttributes().getOrDefault("jira.status.id", null)));
            return new ChangeItem(status.getId(), stepName.orElse(status.getName()));
        }).collect(CollectorsUtil.toImmutableSet());
    }

    private Set<ChangeItem> getActions(JiraWorkflow workflow) {
        return (Set)Optional.ofNullable(workflow).map(JiraWorkflow::getAllActions).orElse((Collection)ImmutableList.of()).stream().map(action -> {
            Optional<Object> sourceStepName;
            ResultDescriptor result = action.getUnconditionalResult();
            if (workflow.isGlobalAction(action)) {
                sourceStepName = Optional.empty();
            } else if (workflow.isCommonAction(action)) {
                Stream<String> stepNames = workflow.getStepsForTransition(action).stream().map(StepDescriptor::getName);
                sourceStepName = Optional.of(String.format("[%s]", stepNames.collect(Collectors.joining(", "))));
            } else {
                sourceStepName = workflow.getStepsForTransition(action).stream().findAny().map(StepDescriptor::getName);
            }
            Optional<String> targetStepName = this.findStatusName(workflow, step -> result.getStep() == step.getId());
            String changeName = sourceStepName.isPresent() && targetStepName.isPresent() ? String.format("%s (%s -> %s)", action.getName(), sourceStepName.orElse(""), targetStepName.orElse("")) : (sourceStepName.isPresent() || targetStepName.isPresent() ? String.format("%s (%s)", action.getName(), sourceStepName.orElse(targetStepName.orElse("Unknown"))) : action.getName());
            return new ChangeItem(Integer.toString(action.getId()), changeName);
        }).collect(CollectorsUtil.toImmutableSet());
    }

    private Optional<String> findStatusName(JiraWorkflow workflow, Predicate<? super StepDescriptor> filterFn) {
        return workflow.getDescriptor().getSteps().stream().filter(filterFn).findAny().map(StepDescriptor::getName);
    }

    static class ChangeItem {
        final String id;
        final String name;

        ChangeItem(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangeItem that = (ChangeItem)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

