/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.jira.auditing.AffectedProject;
import com.atlassian.jira.auditing.AffectedUser;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.HandlerUtils;
import com.atlassian.jira.auditing.handlers.ProjectEventHandler;
import com.atlassian.jira.event.ProjectCreatedEvent;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.ProjectUpdatedEvent;
import com.atlassian.jira.event.project.ProjectArchivedEvent;
import com.atlassian.jira.event.project.ProjectAvatarUpdateEvent;
import com.atlassian.jira.event.project.ProjectCategoryChangeEvent;
import com.atlassian.jira.event.project.ProjectCategoryUpdateEvent;
import com.atlassian.jira.event.project.ProjectRestoredEvent;
import com.atlassian.jira.event.role.ProjectRoleDeletedEvent;
import com.atlassian.jira.event.role.ProjectRoleUpdatedEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ProjectEventHandlerImpl
implements ProjectEventHandler {
    private final I18nHelper.BeanFactory i18n;
    private final ProjectManager projectManager;

    public ProjectEventHandlerImpl(I18nHelper.BeanFactory i18n, ProjectManager projectManager) {
        this.i18n = i18n;
        this.projectManager = projectManager;
    }

    @Override
    public RecordRequest onProjectCreatedEvent(ProjectCreatedEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.created").forObject((AssociatedItem)new AffectedProject(event.getProject())).withAssociatedItems(this.getUserByProjectLeadChange(event.getProject())).withChangedValues(this.buildChangedValues(event.getProject()));
    }

    @Override
    public Option<RecordRequest> onProjectUpdatedEvent(final ProjectUpdatedEvent event) {
        return HandlerUtils.requestIfThereAreAnyValues(this.buildChangedValues(event.getOldProject(), event.getProject()), new Function<List<ChangedValue>, RecordRequest>(){

            public RecordRequest apply(List<ChangedValue> changedValues) {
                return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.updated").forObject((AssociatedItem)new AffectedProject(event.getProject())).withAssociatedItems((Iterable)ProjectEventHandlerImpl.this.getUserByProjectLeadChange(event.getOldProject(), event.getProject())).withChangedValues(changedValues);
            }
        });
    }

    @Override
    public RecordRequest onProjectDeletedEvent(ProjectDeletedEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.deleted").forObject((AssociatedItem)new AffectedProject(event.getProject()));
    }

    @Override
    public RecordRequest onProjectCategoryChangeEvent(ProjectCategoryChangeEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.category.changed").forObject(AssociatedItem.Type.PROJECT, event.getProject().getName(), event.getProject().getId().toString()).withChangedValues(this.buildChangedValuesForCategoryChange(event.getOldProjectCategory(), event.getNewProjectCategory()));
    }

    @Override
    public RecordRequest onProjectAvatarUpdateEvent(ProjectAvatarUpdateEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.avatar.changed").forObject(AssociatedItem.Type.PROJECT, event.getProject().getName(), event.getProject().getId().toString());
    }

    @Override
    public RecordRequest onProjectRoleUpdatedEvent(ProjectRoleUpdatedEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.roles.changed").forObject(AssociatedItem.Type.PROJECT_ROLE, event.getProjectRole().getName(), event.getProjectRole().getId().toString()).withAssociatedItem(AssociatedItem.Type.PROJECT, event.getProject().getName(), event.getProject().getId().toString()).withChangedValues(this.computeChangedValues(event.getOriginalRoleActors(), event.getRoleActors()));
    }

    @Override
    public RecordRequest onProjectRoleDeletedEvent(ProjectRoleDeletedEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.role.deleted").forObject(AssociatedItem.Type.PROJECT_ROLE, event.getProjectRole().getName(), event.getProjectRole().getId().toString());
    }

    @Nonnull
    private List<ChangedValue> computeChangedValues(@Nonnull ProjectRoleActors originalRoleActors, @Nonnull ProjectRoleActors roleActors) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        ListMultimap<String, String> originalActors = this.getCategorisedActors(originalRoleActors);
        List originalUsers = originalActors.get((Object)"atlassian-user-role-actor");
        List originalGroups = originalActors.get((Object)"atlassian-group-role-actor");
        ListMultimap<String, String> newActors = this.getCategorisedActors(roleActors);
        List newUsers = newActors.get((Object)"atlassian-user-role-actor");
        List newGroups = newActors.get((Object)"atlassian-group-role-actor");
        changedValues.addIfDifferent("admin.common.words.users", (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.join((Iterable)originalUsers, (String)", "), null), (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.join((Iterable)newUsers, (String)", "), null));
        changedValues.addIfDifferent("common.words.groups", (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.join((Iterable)originalGroups, (String)", "), null), (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.join((Iterable)newGroups, (String)", "), null));
        return changedValues.build();
    }

    @Nonnull
    private ListMultimap<String, String> getCategorisedActors(ProjectRoleActors originalRoleActors) {
        LinkedListMultimap result = LinkedListMultimap.create((int)2);
        for (RoleActor actor : originalRoleActors.getRoleActors()) {
            result.put((Object)actor.getType(), (Object)actor.getParameter());
        }
        return result;
    }

    @Override
    public Option<RecordRequest> onProjectCategoryUpdateEvent(ProjectCategoryUpdateEvent event) {
        Collection projectsFromProjectCategory = this.projectManager.getProjectsFromProjectCategory(event.getOldProjectCategory());
        if (!projectsFromProjectCategory.isEmpty()) {
            RecordRequest recordRequest = new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.category.updated").forObject(AssociatedItem.Type.PROJECT_CATEGORY, event.getNewProjectCategory().getName()).withChangedValues(this.buildChangedValuesForCategoryUpdate(event.getOldProjectCategory(), event.getNewProjectCategory())).withAssociatedItems(Iterables.transform((Iterable)projectsFromProjectCategory, (Function)new Function<Project, AssociatedItem>(){

                public AssociatedItem apply(Project project) {
                    return new AffectedProject(project);
                }
            }));
            return Option.option((Object)recordRequest);
        }
        return Option.none();
    }

    @Override
    public RecordRequest onProjectArchivedEvent(ProjectArchivedEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.archived").forObject(AssociatedItem.Type.PROJECT, event.getProject().getName(), event.getProject().getId().toString());
    }

    @Override
    public RecordRequest onProjectRestoredEvent(ProjectRestoredEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.restored").forObject(AssociatedItem.Type.PROJECT, event.getProject().getName(), event.getProject().getId().toString());
    }

    private ImmutableList<AssociatedItem> getUserByProjectLeadChange(Project project) {
        return this.getUserByProjectLeadChange(null, project);
    }

    private ImmutableList<AssociatedItem> getUserByProjectLeadChange(Project oldProject, Project project) {
        if (oldProject == null || !project.getProjectLead().equals((Object)oldProject.getProjectLead())) {
            return ImmutableList.of((Object)new AffectedUser(project.getProjectLead()));
        }
        return ImmutableList.of();
    }

    private List<ChangedValue> buildChangedValues(Project project) {
        return this.buildChangedValues(null, project);
    }

    private List<ChangedValue> buildChangedValues(Project originalProject, Project currentProject) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.words.name", originalProject == null ? null : originalProject.getName(), currentProject.getName());
        changedValues.addIfDifferent("common.words.key", originalProject == null ? null : originalProject.getKey(), currentProject.getKey());
        changedValues.addIfDifferent("common.concepts.description", originalProject == null ? null : originalProject.getDescription(), currentProject.getDescription());
        changedValues.addIfDifferent("common.concepts.url", originalProject == null ? null : originalProject.getUrl(), currentProject.getUrl());
        changedValues.addIfDifferent("common.concepts.projectlead", originalProject == null ? null : originalProject.getLeadUserName(), currentProject.getLeadUserName());
        changedValues.addIfDifferent("admin.projects.default.assignee", originalProject == null ? null : this.pre(originalProject.getAssigneeType()), this.pre(currentProject.getAssigneeType()));
        return changedValues.build();
    }

    private List<ChangedValue> buildChangedValuesForCategoryChange(ProjectCategory oldProjectCategory, ProjectCategory newProjectCategory) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        return changedValues.addIfDifferent("common.concepts.category", this.getNameOrNone(oldProjectCategory), this.getNameOrNone(newProjectCategory)).build();
    }

    private List<ChangedValue> buildChangedValuesForCategoryUpdate(ProjectCategory oldProjectCategory, ProjectCategory newProjectCategory) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.concepts.name", oldProjectCategory.getName(), newProjectCategory.getName());
        changedValues.addIfDifferent("common.concepts.description", oldProjectCategory.getDescription(), newProjectCategory.getDescription());
        return changedValues.build();
    }

    private String pre(Long assigneeType) {
        return this.getI18n().getText(ProjectAssigneeTypes.getPrettyAssigneeType((Long)assigneeType));
    }

    protected I18nHelper getI18n() {
        return this.i18n.getInstance(Locale.ENGLISH);
    }

    private String getNameOrNone(ProjectCategory category) {
        return category != null ? category.getName() : "None";
    }
}

