/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@ExperimentalApi
public enum AuditingRetentionPeriod {
    ONE_MONTH("1", "jira.auditing.retention.period.one.month"),
    THREE_MONTHS("3", "jira.auditing.retention.period.three.months"),
    SIX_MONTHS("6", "jira.auditing.retention.period.six.months"),
    UNLIMITED("-1", "jira.auditing.retention.period.unlimited");

    private final String value;
    private final String nameI18nKey;
    private static final Map<String, AuditingRetentionPeriod> periodsByValue;

    private AuditingRetentionPeriod(String value, String nameI18nKey) {
        this.value = value;
        this.nameI18nKey = nameI18nKey;
    }

    public String getValue() {
        return this.value;
    }

    public String getNameI18nKey() {
        return this.nameI18nKey;
    }

    @Nullable
    public static AuditingRetentionPeriod getByValue(String value) {
        if (!periodsByValue.containsKey(value)) {
            return null;
        }
        return periodsByValue.get(value);
    }

    public static List<AuditingRetentionPeriod> getValidValues() {
        return ImmutableList.of((Object)((Object)ONE_MONTH), (Object)((Object)THREE_MONTHS), (Object)((Object)SIX_MONTHS), (Object)((Object)UNLIMITED));
    }

    public static AuditingRetentionPeriod getDefault() {
        return UNLIMITED;
    }

    public boolean isShorterThan(AuditingRetentionPeriod that) {
        if (this.isUnlimited()) {
            return false;
        }
        if (that.isUnlimited()) {
            return true;
        }
        return this.getNumberOfMonths() < that.getNumberOfMonths();
    }

    public boolean isUnlimited() {
        return this == UNLIMITED;
    }

    public DateTime monthsIntoPast() {
        return DateTime.now().minusMonths(this.getNumberOfMonths());
    }

    private int getNumberOfMonths() {
        if (this == UNLIMITED) {
            throw new RuntimeException("There is no number of months value for UNLIMITED");
        }
        return Integer.parseInt(this.getValue());
    }

    static {
        periodsByValue = ImmutableMap.of((Object)ONE_MONTH.getValue(), (Object)((Object)ONE_MONTH), (Object)THREE_MONTHS.getValue(), (Object)((Object)THREE_MONTHS), (Object)SIX_MONTHS.getValue(), (Object)((Object)SIX_MONTHS), (Object)UNLIMITED.getValue(), (Object)((Object)UNLIMITED));
    }
}

