/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AffectedUser
implements AssociatedItem {
    private final String username;
    private final String userKey;
    private final String directoryName;
    private final String directoryId;

    public AffectedUser(com.atlassian.crowd.model.user.User user) {
        this(user.getName(), ApplicationUsers.getKeyFor((User)user), AffectedUser.getDirectoryById(user.getDirectoryId()));
    }

    public AffectedUser(ApplicationUser user) {
        this(user.getName(), user.getKey(), AffectedUser.getDirectoryById(user.getDirectoryId()));
    }

    public AffectedUser(@Nonnull String username, @Nullable String userKey, @Nonnull Directory directory) {
        this.username = username;
        this.userKey = userKey;
        this.directoryName = directory.getName();
        this.directoryId = directory.getId().toString();
    }

    @Nonnull
    public String getObjectName() {
        return this.username;
    }

    public String getObjectId() {
        return this.userKey;
    }

    @Nullable
    public String getParentName() {
        return this.directoryName;
    }

    @Nullable
    public String getParentId() {
        return this.directoryId;
    }

    @Nonnull
    public AssociatedItem.Type getObjectType() {
        return AssociatedItem.Type.USER;
    }

    private static Directory getDirectoryById(long directoryId) {
        return ComponentAccessor.getUserManager().getDirectory(Long.valueOf(directoryId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffectedUser that = (AffectedUser)o;
        return Objects.equals(this.userKey, that.userKey) && Objects.equals(this.directoryId, that.directoryId);
    }

    public int hashCode() {
        return Objects.hash(this.userKey, this.directoryId);
    }
}

