/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency;

import com.atlassian.johnson.event.EventLevel;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class FakeHealthCheckEvent {
    private final EventLevel eventLevel;
    private final boolean dismissible;

    @Nonnull
    static FakeHealthCheckEvent createPhase(String error) {
        String[] errorParsed = error.split("-");
        boolean isDismissible = FakeHealthCheckEvent.getDismissible(errorParsed);
        return new FakeHealthCheckEvent(errorParsed[0], isDismissible);
    }

    private static boolean getDismissible(String[] errorParsed) {
        if (errorParsed.length < 2) {
            return false;
        }
        if (errorParsed[1].equals("dismissible")) {
            return true;
        }
        throw new RuntimeException("FakeHealthCheckEvent's attribute '" + errorParsed[1] + "' is not supported.");
    }

    private FakeHealthCheckEvent(String level, boolean isDismissible) {
        this.eventLevel = EventLevel.get((String)level);
        this.dismissible = isDismissible;
    }

    EventLevel getLevel() {
        return this.eventLevel;
    }

    boolean isDismissible() {
        return this.dismissible;
    }
}

