/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diff;

import com.atlassian.diff.CharacterChunk;
import com.atlassian.diff.DiffChunk;
import com.atlassian.diff.DiffType;
import java.util.ArrayList;
import java.util.List;

public class WordChunk
implements DiffChunk {
    private DiffType type;
    private List<CharacterChunk> characterChunks;
    private String text;

    public WordChunk(DiffType type, String text) {
        this.type = type;
        this.text = text;
    }

    public WordChunk(DiffType type, List<CharacterChunk> characterChunks) {
        this.type = type;
        this.characterChunks = new ArrayList<CharacterChunk>(characterChunks);
    }

    @Override
    public DiffType getType() {
        return this.type;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public boolean isChangedChunk() {
        return this.type == DiffType.CHANGED_WORDS;
    }

    public List<CharacterChunk> getCharacterChunks() {
        return this.characterChunks;
    }

    public String toString() {
        return "" + (Object)((Object)this.type) + " : " + (this.text != null ? this.text : this.characterChunks);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordChunk wordChunk = (WordChunk)o;
        if (this.characterChunks != null ? !this.characterChunks.equals(wordChunk.characterChunks) : wordChunk.characterChunks != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(wordChunk.text) : wordChunk.text != null) {
            return false;
        }
        return this.type == wordChunk.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.characterChunks != null ? this.characterChunks.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        return result;
    }
}

