/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.event;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.txnaware.TxnAwareEventFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class FireIssueEventFunction
implements FunctionProvider {
    public void execute(Map transientVars, Map args, PropertySet ps) {
        Long eventTypeId = null;
        Object object = args.get("eventTypeId");
        if (object instanceof Long) {
            eventTypeId = (Long)args.get("eventTypeId");
        } else if (object instanceof String) {
            eventTypeId = new Long((String)object);
        }
        if (eventTypeId != null) {
            Issue updatedIssue = (Issue)transientVars.get("issue");
            Comment comment = (Comment)transientVars.get("commentValue");
            GenericValue changeGroup = (GenericValue)transientVars.get("changeGroup");
            String originalAssigneeId = (String)transientVars.get("originalAssigneeId");
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("eventsource", "workflow");
            boolean sendMail = true;
            if (transientVars.get("sendBulkNotification") != null) {
                sendMail = this.getBool(transientVars, "sendBulkNotification");
            }
            ApplicationUser caller = WorkflowUtil.getCallerUser((Map)transientVars);
            this.getIssueEventManager().dispatchRedundantEvent(eventTypeId, updatedIssue, caller, comment, null, changeGroup, params, sendMail);
            IssueEventBundle eventBundle = this.getIssueEventBundleFactory().createWorkflowEventBundle(eventTypeId, updatedIssue, caller, comment, changeGroup, params, sendMail, originalAssigneeId);
            this.getIssueEventManager().dispatchEvent(eventBundle);
            if (changeGroup != null) {
                this.getTxnAwareEventFactory().issueChangedEventOnCommit(updatedIssue.getId(), caller, comment, changeGroup.getLong("id"));
            }
        }
    }

    private boolean getBool(Map transientVars, String name) {
        return (Boolean)transientVars.get(name);
    }

    private IssueEventManager getIssueEventManager() {
        return ComponentAccessor.getIssueEventManager();
    }

    private IssueEventBundleFactory getIssueEventBundleFactory() {
        return (IssueEventBundleFactory)ComponentAccessor.getComponent(IssueEventBundleFactory.class);
    }

    @VisibleForTesting
    TxnAwareEventFactory getTxnAwareEventFactory() {
        return (TxnAwareEventFactory)ComponentAccessor.getComponent(TxnAwareEventFactory.class);
    }

    public static FunctionDescriptor makeDescriptor(Long eventTypeId) {
        FunctionDescriptor descriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        descriptor.setType("class");
        descriptor.getArgs().put("class.name", FireIssueEventFunction.class.getName());
        descriptor.getArgs().put("eventTypeId", eventTypeId);
        return descriptor;
    }
}

